/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.AssignmentOperationExpr;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_ExprStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.ReferenceConstructorExpr;
import com.google.api.generator.engine.ast.ReturnExpr;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.ThrowExpr;
import com.google.api.generator.engine.ast.UnaryOperationExpr;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class ExprStatement
implements Statement {
    public abstract Expr expression();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static ExprStatement withExpr(Expr expr) {
        return ExprStatement.builder().setExpression(expr).build();
    }

    static Builder builder() {
        return new AutoValue_ExprStatement.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setExpression(Expr var1);

        abstract ExprStatement autoBuild();

        public ExprStatement build() {
            ExprStatement exprStatement = this.autoBuild();
            Expr expr = exprStatement.expression();
            if (expr instanceof VariableExpr) {
                VariableExpr variableExpr = (VariableExpr)expr;
                Preconditions.checkState(variableExpr.isDecl(), "Expression variable statements must be declarations");
            } else {
                Preconditions.checkState(expr instanceof MethodInvocationExpr || expr instanceof ReferenceConstructorExpr || expr instanceof AssignmentExpr || expr instanceof AssignmentOperationExpr || expr instanceof ThrowExpr || expr instanceof ReturnExpr || expr instanceof UnaryOperationExpr && ((UnaryOperationExpr)expr).isPostfixIncrement(), "Expression statements must be either a method invocation, assignment, throw, this/super constructor, return, or unary post-fix operation expression");
            }
            return exprStatement;
        }
    }
}

