/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.CommonProto;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.TlsParametersOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class TlsParameters
extends GeneratedMessageV3
implements TlsParametersOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int TLS_MINIMUM_PROTOCOL_VERSION_FIELD_NUMBER = 1;
    private int tlsMinimumProtocolVersion_;
    public static final int TLS_MAXIMUM_PROTOCOL_VERSION_FIELD_NUMBER = 2;
    private int tlsMaximumProtocolVersion_;
    public static final int CIPHER_SUITES_FIELD_NUMBER = 3;
    private LazyStringList cipherSuites_;
    public static final int ECDH_CURVES_FIELD_NUMBER = 4;
    private LazyStringList ecdhCurves_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final TlsParameters DEFAULT_INSTANCE = new TlsParameters();
    private static final Parser<TlsParameters> PARSER = new AbstractParser<TlsParameters>(){

        @Override
        public TlsParameters parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = TlsParameters.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private TlsParameters(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private TlsParameters() {
        this.tlsMinimumProtocolVersion_ = 0;
        this.tlsMaximumProtocolVersion_ = 0;
        this.cipherSuites_ = LazyStringArrayList.EMPTY;
        this.ecdhCurves_ = LazyStringArrayList.EMPTY;
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new TlsParameters();
    }

    @Override
    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CommonProto.internal_static_envoy_api_v2_auth_TlsParameters_descriptor;
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CommonProto.internal_static_envoy_api_v2_auth_TlsParameters_fieldAccessorTable.ensureFieldAccessorsInitialized(TlsParameters.class, Builder.class);
    }

    @Override
    public int getTlsMinimumProtocolVersionValue() {
        return this.tlsMinimumProtocolVersion_;
    }

    @Override
    public TlsProtocol getTlsMinimumProtocolVersion() {
        TlsProtocol result = TlsProtocol.valueOf(this.tlsMinimumProtocolVersion_);
        return result == null ? TlsProtocol.UNRECOGNIZED : result;
    }

    @Override
    public int getTlsMaximumProtocolVersionValue() {
        return this.tlsMaximumProtocolVersion_;
    }

    @Override
    public TlsProtocol getTlsMaximumProtocolVersion() {
        TlsProtocol result = TlsProtocol.valueOf(this.tlsMaximumProtocolVersion_);
        return result == null ? TlsProtocol.UNRECOGNIZED : result;
    }

    public ProtocolStringList getCipherSuitesList() {
        return this.cipherSuites_;
    }

    @Override
    public int getCipherSuitesCount() {
        return this.cipherSuites_.size();
    }

    @Override
    public String getCipherSuites(int index) {
        return (String)this.cipherSuites_.get(index);
    }

    @Override
    public ByteString getCipherSuitesBytes(int index) {
        return this.cipherSuites_.getByteString(index);
    }

    public ProtocolStringList getEcdhCurvesList() {
        return this.ecdhCurves_;
    }

    @Override
    public int getEcdhCurvesCount() {
        return this.ecdhCurves_.size();
    }

    @Override
    public String getEcdhCurves(int index) {
        return (String)this.ecdhCurves_.get(index);
    }

    @Override
    public ByteString getEcdhCurvesBytes(int index) {
        return this.ecdhCurves_.getByteString(index);
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.tlsMinimumProtocolVersion_ != TlsProtocol.TLS_AUTO.getNumber()) {
            output.writeEnum(1, this.tlsMinimumProtocolVersion_);
        }
        if (this.tlsMaximumProtocolVersion_ != TlsProtocol.TLS_AUTO.getNumber()) {
            output.writeEnum(2, this.tlsMaximumProtocolVersion_);
        }
        for (i = 0; i < this.cipherSuites_.size(); ++i) {
            GeneratedMessageV3.writeString(output, 3, this.cipherSuites_.getRaw(i));
        }
        for (i = 0; i < this.ecdhCurves_.size(); ++i) {
            GeneratedMessageV3.writeString(output, 4, this.ecdhCurves_.getRaw(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.tlsMinimumProtocolVersion_ != TlsProtocol.TLS_AUTO.getNumber()) {
            size += CodedOutputStream.computeEnumSize(1, this.tlsMinimumProtocolVersion_);
        }
        if (this.tlsMaximumProtocolVersion_ != TlsProtocol.TLS_AUTO.getNumber()) {
            size += CodedOutputStream.computeEnumSize(2, this.tlsMaximumProtocolVersion_);
        }
        int dataSize = 0;
        for (i = 0; i < this.cipherSuites_.size(); ++i) {
            dataSize += TlsParameters.computeStringSizeNoTag(this.cipherSuites_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getCipherSuitesList().size();
        dataSize = 0;
        for (i = 0; i < this.ecdhCurves_.size(); ++i) {
            dataSize += TlsParameters.computeStringSizeNoTag(this.ecdhCurves_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getEcdhCurvesList().size();
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TlsParameters)) {
            return super.equals(obj);
        }
        TlsParameters other = (TlsParameters)obj;
        if (this.tlsMinimumProtocolVersion_ != other.tlsMinimumProtocolVersion_) {
            return false;
        }
        if (this.tlsMaximumProtocolVersion_ != other.tlsMaximumProtocolVersion_) {
            return false;
        }
        if (!this.getCipherSuitesList().equals(other.getCipherSuitesList())) {
            return false;
        }
        if (!this.getEcdhCurvesList().equals(other.getEcdhCurvesList())) {
            return false;
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + TlsParameters.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.tlsMinimumProtocolVersion_;
        hash = 37 * hash + 2;
        hash = 53 * hash + this.tlsMaximumProtocolVersion_;
        if (this.getCipherSuitesCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getCipherSuitesList().hashCode();
        }
        if (this.getEcdhCurvesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getEcdhCurvesList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static TlsParameters parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static TlsParameters parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static TlsParameters parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static TlsParameters parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static TlsParameters parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static TlsParameters parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static TlsParameters parseFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static TlsParameters parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static TlsParameters parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static TlsParameters parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static TlsParameters parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static TlsParameters parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return TlsParameters.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TlsParameters prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static TlsParameters getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<TlsParameters> parser() {
        return PARSER;
    }

    public Parser<TlsParameters> getParserForType() {
        return PARSER;
    }

    @Override
    public TlsParameters getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements TlsParametersOrBuilder {
        private int bitField0_;
        private int tlsMinimumProtocolVersion_ = 0;
        private int tlsMaximumProtocolVersion_ = 0;
        private LazyStringList cipherSuites_ = LazyStringArrayList.EMPTY;
        private LazyStringList ecdhCurves_ = LazyStringArrayList.EMPTY;

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonProto.internal_static_envoy_api_v2_auth_TlsParameters_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonProto.internal_static_envoy_api_v2_auth_TlsParameters_fieldAccessorTable.ensureFieldAccessorsInitialized(TlsParameters.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.tlsMinimumProtocolVersion_ = 0;
            this.tlsMaximumProtocolVersion_ = 0;
            this.cipherSuites_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.ecdhCurves_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return CommonProto.internal_static_envoy_api_v2_auth_TlsParameters_descriptor;
        }

        @Override
        public TlsParameters getDefaultInstanceForType() {
            return TlsParameters.getDefaultInstance();
        }

        @Override
        public TlsParameters build() {
            TlsParameters result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public TlsParameters buildPartial() {
            TlsParameters result = new TlsParameters(this);
            int from_bitField0_ = this.bitField0_;
            result.tlsMinimumProtocolVersion_ = this.tlsMinimumProtocolVersion_;
            result.tlsMaximumProtocolVersion_ = this.tlsMaximumProtocolVersion_;
            if ((this.bitField0_ & 1) != 0) {
                this.cipherSuites_ = this.cipherSuites_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.cipherSuites_ = this.cipherSuites_;
            if ((this.bitField0_ & 2) != 0) {
                this.ecdhCurves_ = this.ecdhCurves_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.ecdhCurves_ = this.ecdhCurves_;
            this.onBuilt();
            return result;
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        @Override
        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        @Override
        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        @Override
        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof TlsParameters) {
                return this.mergeFrom((TlsParameters)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(TlsParameters other) {
            if (other == TlsParameters.getDefaultInstance()) {
                return this;
            }
            if (other.tlsMinimumProtocolVersion_ != 0) {
                this.setTlsMinimumProtocolVersionValue(other.getTlsMinimumProtocolVersionValue());
            }
            if (other.tlsMaximumProtocolVersion_ != 0) {
                this.setTlsMaximumProtocolVersionValue(other.getTlsMaximumProtocolVersionValue());
            }
            if (!other.cipherSuites_.isEmpty()) {
                if (this.cipherSuites_.isEmpty()) {
                    this.cipherSuites_ = other.cipherSuites_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureCipherSuitesIsMutable();
                    this.cipherSuites_.addAll(other.cipherSuites_);
                }
                this.onChanged();
            }
            if (!other.ecdhCurves_.isEmpty()) {
                if (this.ecdhCurves_.isEmpty()) {
                    this.ecdhCurves_ = other.ecdhCurves_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureEcdhCurvesIsMutable();
                    this.ecdhCurves_.addAll(other.ecdhCurves_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block12: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block12;
                        }
                        case 8: {
                            this.tlsMinimumProtocolVersion_ = input.readEnum();
                            continue block12;
                        }
                        case 16: {
                            this.tlsMaximumProtocolVersion_ = input.readEnum();
                            continue block12;
                        }
                        case 26: {
                            String s2 = input.readStringRequireUtf8();
                            this.ensureCipherSuitesIsMutable();
                            this.cipherSuites_.add(s2);
                            continue block12;
                        }
                        case 34: {
                            String s2 = input.readStringRequireUtf8();
                            this.ensureEcdhCurvesIsMutable();
                            this.ecdhCurves_.add(s2);
                            continue block12;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public int getTlsMinimumProtocolVersionValue() {
            return this.tlsMinimumProtocolVersion_;
        }

        public Builder setTlsMinimumProtocolVersionValue(int value) {
            this.tlsMinimumProtocolVersion_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public TlsProtocol getTlsMinimumProtocolVersion() {
            TlsProtocol result = TlsProtocol.valueOf(this.tlsMinimumProtocolVersion_);
            return result == null ? TlsProtocol.UNRECOGNIZED : result;
        }

        public Builder setTlsMinimumProtocolVersion(TlsProtocol value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.tlsMinimumProtocolVersion_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTlsMinimumProtocolVersion() {
            this.tlsMinimumProtocolVersion_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getTlsMaximumProtocolVersionValue() {
            return this.tlsMaximumProtocolVersion_;
        }

        public Builder setTlsMaximumProtocolVersionValue(int value) {
            this.tlsMaximumProtocolVersion_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public TlsProtocol getTlsMaximumProtocolVersion() {
            TlsProtocol result = TlsProtocol.valueOf(this.tlsMaximumProtocolVersion_);
            return result == null ? TlsProtocol.UNRECOGNIZED : result;
        }

        public Builder setTlsMaximumProtocolVersion(TlsProtocol value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.tlsMaximumProtocolVersion_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTlsMaximumProtocolVersion() {
            this.tlsMaximumProtocolVersion_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureCipherSuitesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.cipherSuites_ = new LazyStringArrayList(this.cipherSuites_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getCipherSuitesList() {
            return this.cipherSuites_.getUnmodifiableView();
        }

        @Override
        public int getCipherSuitesCount() {
            return this.cipherSuites_.size();
        }

        @Override
        public String getCipherSuites(int index) {
            return (String)this.cipherSuites_.get(index);
        }

        @Override
        public ByteString getCipherSuitesBytes(int index) {
            return this.cipherSuites_.getByteString(index);
        }

        public Builder setCipherSuites(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCipherSuitesIsMutable();
            this.cipherSuites_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addCipherSuites(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCipherSuitesIsMutable();
            this.cipherSuites_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllCipherSuites(Iterable<String> values) {
            this.ensureCipherSuitesIsMutable();
            AbstractMessageLite.Builder.addAll(values, this.cipherSuites_);
            this.onChanged();
            return this;
        }

        public Builder clearCipherSuites() {
            this.cipherSuites_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addCipherSuitesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TlsParameters.checkByteStringIsUtf8(value);
            this.ensureCipherSuitesIsMutable();
            this.cipherSuites_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureEcdhCurvesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.ecdhCurves_ = new LazyStringArrayList(this.ecdhCurves_);
                this.bitField0_ |= 2;
            }
        }

        public ProtocolStringList getEcdhCurvesList() {
            return this.ecdhCurves_.getUnmodifiableView();
        }

        @Override
        public int getEcdhCurvesCount() {
            return this.ecdhCurves_.size();
        }

        @Override
        public String getEcdhCurves(int index) {
            return (String)this.ecdhCurves_.get(index);
        }

        @Override
        public ByteString getEcdhCurvesBytes(int index) {
            return this.ecdhCurves_.getByteString(index);
        }

        public Builder setEcdhCurves(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureEcdhCurvesIsMutable();
            this.ecdhCurves_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addEcdhCurves(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureEcdhCurvesIsMutable();
            this.ecdhCurves_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllEcdhCurves(Iterable<String> values) {
            this.ensureEcdhCurvesIsMutable();
            AbstractMessageLite.Builder.addAll(values, this.ecdhCurves_);
            this.onChanged();
            return this;
        }

        public Builder clearEcdhCurves() {
            this.ecdhCurves_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder addEcdhCurvesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TlsParameters.checkByteStringIsUtf8(value);
            this.ensureEcdhCurvesIsMutable();
            this.ecdhCurves_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum TlsProtocol implements ProtocolMessageEnum
    {
        TLS_AUTO(0),
        TLSv1_0(1),
        TLSv1_1(2),
        TLSv1_2(3),
        TLSv1_3(4),
        UNRECOGNIZED(-1);

        public static final int TLS_AUTO_VALUE = 0;
        public static final int TLSv1_0_VALUE = 1;
        public static final int TLSv1_1_VALUE = 2;
        public static final int TLSv1_2_VALUE = 3;
        public static final int TLSv1_3_VALUE = 4;
        private static final Internal.EnumLiteMap<TlsProtocol> internalValueMap;
        private static final TlsProtocol[] VALUES;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static TlsProtocol valueOf(int value) {
            return TlsProtocol.forNumber(value);
        }

        public static TlsProtocol forNumber(int value) {
            switch (value) {
                case 0: {
                    return TLS_AUTO;
                }
                case 1: {
                    return TLSv1_0;
                }
                case 2: {
                    return TLSv1_1;
                }
                case 3: {
                    return TLSv1_2;
                }
                case 4: {
                    return TLSv1_3;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<TlsProtocol> internalGetValueMap() {
            return internalValueMap;
        }

        @Override
        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return TlsProtocol.getDescriptor().getValues().get(this.ordinal());
        }

        @Override
        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return TlsProtocol.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return TlsParameters.getDescriptor().getEnumTypes().get(0);
        }

        public static TlsProtocol valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != TlsProtocol.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private TlsProtocol(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<TlsProtocol>(){

                @Override
                public TlsProtocol findValueByNumber(int number) {
                    return TlsProtocol.forNumber(number);
                }
            };
            VALUES = TlsProtocol.values();
        }
    }
}

