/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.openjdk.source.tree.AnnotatedTypeTree;
import org.openjdk.source.tree.AnnotationTree;
import org.openjdk.source.tree.ArrayTypeTree;
import org.openjdk.source.tree.Tree;
import org.openjdk.tools.javac.tree.JCTree;

class DimensionHelpers {
    DimensionHelpers() {
    }

    static TypeWithDims extractDims(Tree node, SortedDims sorted2) {
        ArrayDeque<List<AnnotationTree>> builder = new ArrayDeque<List<AnnotationTree>>();
        node = DimensionHelpers.extractDims(builder, node);
        Iterable<List<AnnotationTree>> dims = sorted2 == SortedDims.YES ? DimensionHelpers.reorderBySourcePosition(builder) : builder;
        return new TypeWithDims(node, ImmutableList.copyOf(dims));
    }

    private static Iterable<List<AnnotationTree>> reorderBySourcePosition(Deque<List<AnnotationTree>> dims) {
        int lastAnnotation = -1;
        int lastPos = -1;
        int idx = 0;
        for (List<AnnotationTree> dim : dims) {
            if (!dim.isEmpty()) {
                int pos = ((JCTree)((Object)dim.get(0))).getStartPosition();
                if (pos < lastPos) {
                    ArrayList<List<AnnotationTree>> list = new ArrayList<List<AnnotationTree>>(dims);
                    Collections.rotate(list, -(lastAnnotation + 1));
                    return list;
                }
                lastPos = pos;
                lastAnnotation = idx;
            }
            ++idx;
        }
        return dims;
    }

    private static Tree extractDims(Deque<List<AnnotationTree>> dims, Tree node) {
        switch (node.getKind()) {
            case ARRAY_TYPE: {
                return DimensionHelpers.extractDims(dims, ((ArrayTypeTree)node).getType());
            }
            case ANNOTATED_TYPE: {
                AnnotatedTypeTree annotatedTypeTree = (AnnotatedTypeTree)node;
                if (annotatedTypeTree.getUnderlyingType().getKind() != Tree.Kind.ARRAY_TYPE) {
                    return node;
                }
                node = DimensionHelpers.extractDims(dims, annotatedTypeTree.getUnderlyingType());
                dims.addFirst(ImmutableList.copyOf(annotatedTypeTree.getAnnotations()));
                return node;
            }
        }
        return node;
    }

    static enum SortedDims {
        YES,
        NO;

    }

    static class TypeWithDims {
        final Tree node;
        final ImmutableList<List<AnnotationTree>> dims;

        public TypeWithDims(Tree node, ImmutableList<List<AnnotationTree>> dims) {
            this.node = node;
            this.dims = dims;
        }
    }
}

