/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.utils;

import com.google.api.generator.engine.lexicon.Keyword;
import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import java.util.stream.IntStream;

public class JavaStyle {
    private static final String UNDERSCORE = "_";

    public static String toLowerCamelCase(String s2) {
        String name;
        if (Strings.isNullOrEmpty(s2)) {
            return s2;
        }
        if ((s2 = s2.replace('-', '_')).indexOf(UNDERSCORE) >= 0) {
            s2 = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s2);
        }
        return Keyword.isKeyword(name = JavaStyle.capitalizeLettersAfterDigits(String.format("%s%s", s2.substring(0, 1).toLowerCase(), s2.substring(1)))) ? name + '_' : name;
    }

    public static String toUpperCamelCase(String s2) {
        if (Strings.isNullOrEmpty(s2)) {
            return s2;
        }
        if ((s2 = s2.replace('-', '_')).indexOf(UNDERSCORE) >= 0) {
            s2 = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s2);
        }
        return JavaStyle.capitalizeLettersAfterDigits(String.format("%s%s", s2.substring(0, 1).toUpperCase(), s2.substring(1)));
    }

    public static String toUpperSnakeCase(String s2) {
        String result = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, JavaStyle.toUpperCamelCase(s2));
        return result;
    }

    private static String capitalizeLettersAfterDigits(String s2) {
        return IntStream.range(0, s2.length()).collect(StringBuilder::new, (sb, i) -> sb.append(i > 0 && Character.isDigit(s2.charAt(i - 1)) ? Character.toUpperCase(s2.charAt(i)) : s2.charAt(i)), StringBuilder::append).toString();
    }
}

