/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.gapic.model.GapicLroRetrySettings;

final class AutoValue_GapicLroRetrySettings
extends GapicLroRetrySettings {
    private final String protoPakkage;
    private final String serviceName;
    private final String methodName;
    private final long initialPollDelayMillis;
    private final double pollDelayMultiplier;
    private final long maxPollDelayMillis;
    private final long totalPollTimeoutMillis;

    private AutoValue_GapicLroRetrySettings(String protoPakkage, String serviceName, String methodName, long initialPollDelayMillis, double pollDelayMultiplier, long maxPollDelayMillis, long totalPollTimeoutMillis) {
        this.protoPakkage = protoPakkage;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.initialPollDelayMillis = initialPollDelayMillis;
        this.pollDelayMultiplier = pollDelayMultiplier;
        this.maxPollDelayMillis = maxPollDelayMillis;
        this.totalPollTimeoutMillis = totalPollTimeoutMillis;
    }

    @Override
    public String protoPakkage() {
        return this.protoPakkage;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public String methodName() {
        return this.methodName;
    }

    @Override
    public long initialPollDelayMillis() {
        return this.initialPollDelayMillis;
    }

    @Override
    public double pollDelayMultiplier() {
        return this.pollDelayMultiplier;
    }

    @Override
    public long maxPollDelayMillis() {
        return this.maxPollDelayMillis;
    }

    @Override
    public long totalPollTimeoutMillis() {
        return this.totalPollTimeoutMillis;
    }

    public String toString() {
        return "GapicLroRetrySettings{protoPakkage=" + this.protoPakkage + ", serviceName=" + this.serviceName + ", methodName=" + this.methodName + ", initialPollDelayMillis=" + this.initialPollDelayMillis + ", pollDelayMultiplier=" + this.pollDelayMultiplier + ", maxPollDelayMillis=" + this.maxPollDelayMillis + ", totalPollTimeoutMillis=" + this.totalPollTimeoutMillis + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GapicLroRetrySettings) {
            GapicLroRetrySettings that = (GapicLroRetrySettings)o;
            return this.protoPakkage.equals(that.protoPakkage()) && this.serviceName.equals(that.serviceName()) && this.methodName.equals(that.methodName()) && this.initialPollDelayMillis == that.initialPollDelayMillis() && Double.doubleToLongBits(this.pollDelayMultiplier) == Double.doubleToLongBits(that.pollDelayMultiplier()) && this.maxPollDelayMillis == that.maxPollDelayMillis() && this.totalPollTimeoutMillis == that.totalPollTimeoutMillis();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.protoPakkage.hashCode();
        h$ *= 1000003;
        h$ ^= this.serviceName.hashCode();
        h$ *= 1000003;
        h$ ^= this.methodName.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.initialPollDelayMillis >>> 32 ^ this.initialPollDelayMillis);
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.pollDelayMultiplier) >>> 32 ^ Double.doubleToLongBits(this.pollDelayMultiplier));
        h$ *= 1000003;
        h$ ^= (int)(this.maxPollDelayMillis >>> 32 ^ this.maxPollDelayMillis);
        h$ *= 1000003;
        return h$ ^= (int)(this.totalPollTimeoutMillis >>> 32 ^ this.totalPollTimeoutMillis);
    }

    static final class Builder
    extends GapicLroRetrySettings.Builder {
        private String protoPakkage;
        private String serviceName;
        private String methodName;
        private long initialPollDelayMillis;
        private double pollDelayMultiplier;
        private long maxPollDelayMillis;
        private long totalPollTimeoutMillis;
        private byte set$0;

        Builder() {
        }

        @Override
        public GapicLroRetrySettings.Builder setProtoPakkage(String protoPakkage) {
            if (protoPakkage == null) {
                throw new NullPointerException("Null protoPakkage");
            }
            this.protoPakkage = protoPakkage;
            return this;
        }

        @Override
        public GapicLroRetrySettings.Builder setServiceName(String serviceName) {
            if (serviceName == null) {
                throw new NullPointerException("Null serviceName");
            }
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public GapicLroRetrySettings.Builder setMethodName(String methodName) {
            if (methodName == null) {
                throw new NullPointerException("Null methodName");
            }
            this.methodName = methodName;
            return this;
        }

        @Override
        public GapicLroRetrySettings.Builder setInitialPollDelayMillis(long initialPollDelayMillis) {
            this.initialPollDelayMillis = initialPollDelayMillis;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public GapicLroRetrySettings.Builder setPollDelayMultiplier(double pollDelayMultiplier) {
            this.pollDelayMultiplier = pollDelayMultiplier;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public GapicLroRetrySettings.Builder setMaxPollDelayMillis(long maxPollDelayMillis) {
            this.maxPollDelayMillis = maxPollDelayMillis;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public GapicLroRetrySettings.Builder setTotalPollTimeoutMillis(long totalPollTimeoutMillis) {
            this.totalPollTimeoutMillis = totalPollTimeoutMillis;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public GapicLroRetrySettings build() {
            if (this.set$0 != 15 || this.protoPakkage == null || this.serviceName == null || this.methodName == null) {
                StringBuilder missing = new StringBuilder();
                if (this.protoPakkage == null) {
                    missing.append(" protoPakkage");
                }
                if (this.serviceName == null) {
                    missing.append(" serviceName");
                }
                if (this.methodName == null) {
                    missing.append(" methodName");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" initialPollDelayMillis");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" pollDelayMultiplier");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" maxPollDelayMillis");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" totalPollTimeoutMillis");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GapicLroRetrySettings(this.protoPakkage, this.serviceName, this.methodName, this.initialPollDelayMillis, this.pollDelayMultiplier, this.maxPollDelayMillis, this.totalPollTimeoutMillis);
        }
    }
}

