/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AutoValue_StringObjectValue;
import com.google.api.generator.engine.ast.ObjectValue;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;

@AutoValue
public abstract class StringObjectValue
implements ObjectValue {
    @Override
    public abstract String value();

    @Override
    public TypeNode type() {
        return TypeNode.STRING;
    }

    public static Builder builder() {
        return new AutoValue_StringObjectValue.Builder();
    }

    public static StringObjectValue withValue(String value) {
        return StringObjectValue.builder().setValue(value).build();
    }

    private static class StringValueEscaper
    extends Escaper {
        private static final Escaper escaper = Escapers.builder().addEscape('\t', "\\t").addEscape('\b', "\\b").addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\f', "\\f").addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();

        private StringValueEscaper() {
        }

        @Override
        public String escape(String sourceString) {
            return escaper.escape(sourceString);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setValue(String var1);

        abstract String value();

        public abstract StringObjectValue autoBuild();

        public StringObjectValue build() {
            String value = String.format("\"%s\"", StringValueEscaper.escaper.escape(this.value()));
            this.setValue(value);
            return this.autoBuild();
        }
    }
}

