/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.SynchronizedStatement;
import com.google.common.collect.ImmutableList;
import java.util.List;

final class AutoValue_SynchronizedStatement
extends SynchronizedStatement {
    private final Expr lock;
    private final ImmutableList<Statement> body;

    private AutoValue_SynchronizedStatement(Expr lock, ImmutableList<Statement> body) {
        this.lock = lock;
        this.body = body;
    }

    @Override
    public Expr lock() {
        return this.lock;
    }

    @Override
    public ImmutableList<Statement> body() {
        return this.body;
    }

    public String toString() {
        return "SynchronizedStatement{lock=" + this.lock + ", body=" + this.body + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SynchronizedStatement) {
            SynchronizedStatement that = (SynchronizedStatement)o;
            return this.lock.equals(that.lock()) && this.body.equals(that.body());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.lock.hashCode();
        h$ *= 1000003;
        return h$ ^= this.body.hashCode();
    }

    static final class Builder
    extends SynchronizedStatement.Builder {
        private Expr lock;
        private ImmutableList<Statement> body;

        Builder() {
        }

        @Override
        SynchronizedStatement.Builder setLock(Expr lock) {
            if (lock == null) {
                throw new NullPointerException("Null lock");
            }
            this.lock = lock;
            return this;
        }

        @Override
        public SynchronizedStatement.Builder setBody(List<Statement> body) {
            this.body = ImmutableList.copyOf(body);
            return this;
        }

        @Override
        ImmutableList<Statement> body() {
            if (this.body == null) {
                throw new IllegalStateException("Property \"body\" has not been set");
            }
            return this.body;
        }

        @Override
        SynchronizedStatement autoBuild() {
            if (this.lock == null || this.body == null) {
                StringBuilder missing = new StringBuilder();
                if (this.lock == null) {
                    missing.append(" lock");
                }
                if (this.body == null) {
                    missing.append(" body");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SynchronizedStatement(this.lock, this.body);
        }
    }
}

