/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.mtls;

import com.google.api.gax.rpc.mtls.MtlsProvider;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MtlsProviderTest {
    @Test
    public void testUseMtlsEndpointAlways() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "always" : "false", new TestProcessProvider(0), "/path/to/missing/file");
        Assert.assertEquals((Object)MtlsProvider.MtlsEndpointUsagePolicy.ALWAYS, (Object)mtlsProvider.getMtlsEndpointUsagePolicy());
    }

    @Test
    public void testUseMtlsEndpointAuto() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "false", new TestProcessProvider(0), "/path/to/missing/file");
        Assert.assertEquals((Object)MtlsProvider.MtlsEndpointUsagePolicy.AUTO, (Object)mtlsProvider.getMtlsEndpointUsagePolicy());
    }

    @Test
    public void testUseMtlsEndpointNever() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "never" : "false", new TestProcessProvider(0), "/path/to/missing/file");
        Assert.assertEquals((Object)MtlsProvider.MtlsEndpointUsagePolicy.NEVER, (Object)mtlsProvider.getMtlsEndpointUsagePolicy());
    }

    @Test
    public void testUseMtlsClientCertificateTrue() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "true", new TestProcessProvider(0), "/path/to/missing/file");
        Assert.assertTrue(mtlsProvider.useMtlsClientCertificate());
    }

    @Test
    public void testUseMtlsClientCertificateFalse() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "false", new TestProcessProvider(0), "/path/to/missing/file");
        Assert.assertFalse(mtlsProvider.useMtlsClientCertificate());
    }

    @Test
    public void testGetKeyStore() throws IOException {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "always" : "false", new TestProcessProvider(0), "/path/to/missing/file");
        Assert.assertNull(mtlsProvider.getKeyStore());
    }

    @Test
    public void testGetKeyStoreNonZeroExitCode() throws IOException, InterruptedException, GeneralSecurityException {
        try {
            InputStream metadata = this.getClass().getClassLoader().getResourceAsStream("com/google/api/gax/rpc/mtls/mtlsCertAndKey.pem");
            MtlsProvider.getKeyStore(metadata, new TestProcessProvider(1));
            Assert.fail("should throw an exception");
        }
        catch (IOException e) {
            Assert.assertTrue("expected to fail with nonzero exit code", e.getMessage().contains("Cert provider command failed with exit code: 1"));
        }
    }

    @Test
    public void testExtractCertificateProviderCommand() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/google/api/gax/rpc/mtls/mtls_context_aware_metadata.json");
        ImmutableList<String> command = MtlsProvider.extractCertificateProviderCommand(inputStream);
        Assert.assertEquals(2L, command.size());
        Assert.assertEquals("some_binary", command.get(0));
        Assert.assertEquals("some_argument", command.get(1));
    }

    @Test
    public void testRunCertificateProviderCommandSuccess() throws IOException, InterruptedException {
        TestCertProviderCommandProcess certCommandProcess = new TestCertProviderCommandProcess(0, false);
        int exitValue = MtlsProvider.runCertificateProviderCommand(certCommandProcess, 100L);
        Assert.assertEquals(0L, exitValue);
    }

    @Test
    public void testRunCertificateProviderCommandTimeout() throws InterruptedException {
        TestCertProviderCommandProcess certCommandProcess = new TestCertProviderCommandProcess(0, true);
        try {
            MtlsProvider.runCertificateProviderCommand(certCommandProcess, 100L);
            Assert.fail("should throw an exception");
        }
        catch (IOException e) {
            Assert.assertTrue("expected to fail with timeout", e.getMessage().contains("cert provider command timed out"));
        }
    }

    static class TestProcessProvider
    implements MtlsProvider.ProcessProvider {
        private int exitCode;

        public TestProcessProvider(int exitCode) {
            this.exitCode = exitCode;
        }

        @Override
        public Process createProcess(InputStream metadata) throws IOException {
            return new TestCertProviderCommandProcess(this.exitCode, false);
        }
    }

    private static class TestCertProviderCommandProcess
    extends Process {
        private boolean runForever;
        private int exitValue;

        public TestCertProviderCommandProcess(int exitValue, boolean runForever) {
            this.runForever = runForever;
            this.exitValue = exitValue;
        }

        @Override
        public OutputStream getOutputStream() {
            return null;
        }

        @Override
        public InputStream getInputStream() {
            return null;
        }

        @Override
        public InputStream getErrorStream() {
            return null;
        }

        @Override
        public int waitFor() throws InterruptedException {
            return 0;
        }

        @Override
        public int exitValue() {
            if (this.runForever) {
                throw new IllegalThreadStateException();
            }
            return this.exitValue;
        }

        @Override
        public void destroy() {
        }
    }
}

