/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.escapevelocity;

import autovalue.shaded.com.google.common.base.Joiner;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import autovalue.shaded.com.google.common.collect.Iterables;
import autovalue.shaded.com.google.common.primitives.Primitives;
import autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import autovalue.shaded.com.google.escapevelocity.EvaluationException;
import autovalue.shaded.com.google.escapevelocity.ExpressionNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class ReferenceNode
extends ExpressionNode {
    ReferenceNode(String resourceName, int lineNumber) {
        super(resourceName, lineNumber);
    }

    Object invokeMethod(Method method, Object target, List<Object> argValues) {
        try {
            return method.invoke(target, argValues.toArray());
        }
        catch (InvocationTargetException e) {
            throw this.evaluationException(e.getCause());
        }
        catch (Exception e) {
            throw this.evaluationException(e);
        }
    }

    static class MethodReferenceNode
    extends ReferenceNode {
        final ReferenceNode lhs;
        final String id;
        final List<ExpressionNode> args;
        private static final ImmutableList<Class<?>> NUMERICAL_PRIMITIVES = ImmutableList.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
        private static final int INDEX_OF_INT = NUMERICAL_PRIMITIVES.indexOf(Integer.TYPE);

        MethodReferenceNode(ReferenceNode lhs, String id, List<ExpressionNode> args2) {
            super(lhs.resourceName, lhs.lineNumber);
            this.lhs = lhs;
            this.id = id;
            this.args = args2;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            Object lhsValue = this.lhs.evaluate(context);
            if (lhsValue == null) {
                throw this.evaluationException("Cannot invoke method " + this.id + " on null value");
            }
            try {
                return this.evaluate(context, lhsValue, lhsValue.getClass());
            }
            catch (EvaluationException e) {
                if (lhsValue instanceof Class) {
                    return this.evaluate(context, null, (Class)lhsValue);
                }
                throw e;
            }
        }

        private Object evaluate(EvaluationContext context, Object lhsValue, Class<?> targetClass) {
            List<Object> argValues = this.args.stream().map(arg -> arg.evaluate(context)).collect(Collectors.toList());
            ImmutableSet<Method> publicMethodsWithName = context.publicMethodsWithName(targetClass, this.id);
            if (publicMethodsWithName.isEmpty()) {
                throw this.evaluationException("No method " + this.id + " in " + targetClass.getName());
            }
            List compatibleMethods = publicMethodsWithName.stream().filter(method -> MethodReferenceNode.compatibleArgs(method.getParameterTypes(), argValues)).collect(Collectors.toList());
            if (compatibleMethods.size() > 1) {
                compatibleMethods = compatibleMethods.stream().filter(method -> !method.isSynthetic()).collect(Collectors.toList());
            }
            switch (compatibleMethods.size()) {
                case 0: {
                    throw this.evaluationException("Parameters for method " + this.id + " have wrong types: " + argValues);
                }
                case 1: {
                    return this.invokeMethod((Method)Iterables.getOnlyElement(compatibleMethods), lhsValue, argValues);
                }
            }
            throw this.evaluationException("Ambiguous method invocation, could be one of:\n  " + Joiner.on("\n  ").join(compatibleMethods));
        }

        static boolean compatibleArgs(Class<?>[] paramTypes, List<Object> argValues) {
            if (paramTypes.length != argValues.size()) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> paramType = paramTypes[i];
                Object argValue = argValues.get(i);
                if (paramType.isPrimitive()) {
                    return MethodReferenceNode.primitiveIsCompatible(paramType, argValue);
                }
                if (argValue == null || paramType.isInstance(argValue)) continue;
                return false;
            }
            return true;
        }

        private static boolean primitiveIsCompatible(Class<?> primitive, Object value) {
            if (value == null || !Primitives.isWrapperType(value.getClass())) {
                return false;
            }
            return MethodReferenceNode.primitiveTypeIsAssignmentCompatible(primitive, Primitives.unwrap(value.getClass()));
        }

        static boolean primitiveTypeIsAssignmentCompatible(Class<?> to, Class<?> from) {
            if (to == from) {
                return true;
            }
            int toI = NUMERICAL_PRIMITIVES.indexOf(to);
            if (toI < 0) {
                return false;
            }
            if (from == Character.TYPE) {
                return toI >= INDEX_OF_INT;
            }
            int fromI = NUMERICAL_PRIMITIVES.indexOf(from);
            if (fromI < 0) {
                return false;
            }
            return toI >= fromI;
        }
    }

    static class IndexReferenceNode
    extends ReferenceNode {
        final ReferenceNode lhs;
        final ExpressionNode index;

        IndexReferenceNode(ReferenceNode lhs, ExpressionNode index) {
            super(lhs.resourceName, lhs.lineNumber);
            this.lhs = lhs;
            this.index = index;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            Object lhsValue = this.lhs.evaluate(context);
            if (lhsValue == null) {
                throw this.evaluationException("Cannot index null value");
            }
            if (lhsValue instanceof List) {
                Object indexValue = this.index.evaluate(context);
                if (!(indexValue instanceof Integer)) {
                    throw this.evaluationException("List index is not an integer: " + indexValue);
                }
                List lhsList = (List)lhsValue;
                int i = (Integer)indexValue;
                if (i < 0 || i >= lhsList.size()) {
                    throw this.evaluationException("List index " + i + " is not valid for list of size " + lhsList.size());
                }
                return lhsList.get(i);
            }
            if (lhsValue instanceof Map) {
                Object indexValue = this.index.evaluate(context);
                Map lhsMap = (Map)lhsValue;
                return lhsMap.get(indexValue);
            }
            MethodReferenceNode node = new MethodReferenceNode(this.lhs, "get", ImmutableList.of(this.index));
            return node.evaluate(context);
        }
    }

    static class MemberReferenceNode
    extends ReferenceNode {
        final ReferenceNode lhs;
        final String id;
        private static final String[] PREFIXES = new String[]{"get", "is"};
        private static final boolean[] CHANGE_CASE = new boolean[]{false, true};

        MemberReferenceNode(ReferenceNode lhs, String id) {
            super(lhs.resourceName, lhs.lineNumber);
            this.lhs = lhs;
            this.id = id;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            Object lhsValue = this.lhs.evaluate(context);
            if (lhsValue == null) {
                throw this.evaluationException("Cannot get member " + this.id + " of null value");
            }
            if (lhsValue instanceof Map) {
                Map map = (Map)lhsValue;
                return map.get(this.id);
            }
            for (String prefix : PREFIXES) {
                for (boolean changeCase : CHANGE_CASE) {
                    String baseId = changeCase ? MemberReferenceNode.changeInitialCase(this.id) : this.id;
                    String methodName = prefix + baseId;
                    Optional<Method> maybeMethod = context.publicMethodsWithName(lhsValue.getClass(), methodName).stream().filter(m3 -> m3.getParameterTypes().length == 0).findFirst();
                    if (!maybeMethod.isPresent()) continue;
                    Method method = maybeMethod.get();
                    if (prefix.equals("is") && !method.getReturnType().equals(Boolean.TYPE)) continue;
                    return this.invokeMethod(method, lhsValue, ImmutableList.of());
                }
            }
            throw this.evaluationException("Member " + this.id + " does not correspond to a public getter of " + lhsValue + ", a " + lhsValue.getClass().getName());
        }

        private static String changeInitialCase(String id) {
            int initial = id.codePointAt(0);
            String rest = id.substring(Character.charCount(initial));
            if (Character.isUpperCase(initial)) {
                initial = Character.toLowerCase(initial);
            } else if (Character.isLowerCase(initial)) {
                initial = Character.toUpperCase(initial);
            }
            return new StringBuilder().appendCodePoint(initial).append(rest).toString();
        }
    }

    static class PlainReferenceNode
    extends ReferenceNode {
        final String id;

        PlainReferenceNode(String resourceName, int lineNumber, String id) {
            super(resourceName, lineNumber);
            this.id = id;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            if (context.varIsDefined(this.id)) {
                return context.getVar(this.id);
            }
            throw this.evaluationException("Undefined reference $" + this.id);
        }

        @Override
        boolean isDefinedAndTrue(EvaluationContext context) {
            if (context.varIsDefined(this.id)) {
                return this.isTrue(context);
            }
            return false;
        }
    }
}

