/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.FieldInfo;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassInfo {
    private static final Map<Class<?>, ClassInfo> CACHE = new WeakHashMap();
    @Deprecated
    public final Class<?> clazz;
    private final IdentityHashMap<String, FieldInfo> nameToFieldInfoMap = new IdentityHashMap();
    final List<String> names;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInfo of(Class<?> underlyingClass) {
        if (underlyingClass == null) {
            return null;
        }
        Map<Class<?>, ClassInfo> map = CACHE;
        synchronized (map) {
            ClassInfo classInfo = CACHE.get(underlyingClass);
            if (classInfo == null) {
                classInfo = new ClassInfo(underlyingClass);
                CACHE.put(underlyingClass, classInfo);
            }
            return classInfo;
        }
    }

    public Class<?> getUnderlyingClass() {
        return this.clazz;
    }

    public FieldInfo getFieldInfo(String name) {
        return this.nameToFieldInfoMap.get(name == null ? null : name.intern());
    }

    public Field getField(String name) {
        FieldInfo fieldInfo = this.getFieldInfo(name);
        return fieldInfo == null ? null : fieldInfo.getField();
    }

    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    @Deprecated
    public int getKeyCount() {
        return this.nameToFieldInfoMap.size();
    }

    @Deprecated
    public Collection<String> getKeyNames() {
        return this.names;
    }

    public Collection<String> getNames() {
        return this.names;
    }

    @Deprecated
    public static <T> T newInstance(Class<T> clazz) {
        T newInstance;
        try {
            newInstance = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw ClassInfo.handleExceptionForNewInstance(e, clazz);
        }
        catch (InstantiationException e) {
            throw ClassInfo.handleExceptionForNewInstance(e, clazz);
        }
        return newInstance;
    }

    private static IllegalArgumentException handleExceptionForNewInstance(Exception e, Class<?> clazz) {
        StringBuilder buf = new StringBuilder("unable to create new instance of class ").append(clazz.getName());
        if (Modifier.isAbstract(clazz.getModifiers())) {
            buf.append(" (and) because it is abstract");
        }
        if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
            buf.append(" (and) because it is not static");
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            buf.append(" (and) because it is not public");
        } else {
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                buf.append(" (and) because it has no public default constructor");
            }
        }
        throw new IllegalArgumentException(buf.toString(), e);
    }

    @Deprecated
    public static Collection<Object> newCollectionInstance(Class<?> collectionClass) {
        if (collectionClass == null || collectionClass.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<Object>();
        }
        if (0 == (collectionClass.getModifiers() & 0x600)) {
            Collection result = (Collection)ClassInfo.newInstance(collectionClass);
            return result;
        }
        if (collectionClass.isAssignableFrom(HashSet.class)) {
            return new HashSet<Object>();
        }
        if (collectionClass.isAssignableFrom(TreeSet.class)) {
            return new TreeSet<Object>();
        }
        throw new IllegalArgumentException("no default collection class defined for class: " + collectionClass.getName());
    }

    @Deprecated
    public static Map<String, Object> newMapInstance(Class<?> mapClass) {
        if (mapClass != null && 0 == (mapClass.getModifiers() & 0x600)) {
            Map result = (Map)ClassInfo.newInstance(mapClass);
            return result;
        }
        if (mapClass == null || mapClass.isAssignableFrom(ArrayMap.class)) {
            return ArrayMap.create();
        }
        if (mapClass.isAssignableFrom(TreeMap.class)) {
            return new TreeMap<String, Object>();
        }
        throw new IllegalArgumentException("no default map class defined for class: " + mapClass.getName());
    }

    @Deprecated
    public static Class<?> getCollectionParameter(Field field) {
        Type[] typeArgs;
        Type genericType;
        if (field != null && (genericType = field.getGenericType()) instanceof ParameterizedType && (typeArgs = ((ParameterizedType)genericType).getActualTypeArguments()).length == 1 && typeArgs[0] instanceof Class) {
            return (Class)typeArgs[0];
        }
        return null;
    }

    @Deprecated
    public static Class<?> getMapValueParameter(Field field) {
        if (field != null) {
            return ClassInfo.getMapValueParameter(field.getGenericType());
        }
        return null;
    }

    @Deprecated
    public static Class<?> getMapValueParameter(Type genericType) {
        Type[] typeArgs;
        if (genericType instanceof ParameterizedType && (typeArgs = ((ParameterizedType)genericType).getActualTypeArguments()).length == 2 && typeArgs[1] instanceof Class) {
            return (Class)typeArgs[1];
        }
        return null;
    }

    private ClassInfo(Class<?> srcClass) {
        this.clazz = srcClass;
        TreeSet<String> nameSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s0, String s1) {
                return s0 == s1 ? 0 : (s0 == null ? -1 : (s1 == null ? 1 : s0.compareTo(s1)));
            }
        });
        Class<?> superClass = srcClass.getSuperclass();
        if (superClass != null) {
            ClassInfo superClassInfo = ClassInfo.of(superClass);
            this.nameToFieldInfoMap.putAll(superClassInfo.nameToFieldInfoMap);
            nameSet.addAll(superClassInfo.names);
        }
        for (Field field : srcClass.getDeclaredFields()) {
            FieldInfo fieldInfo = FieldInfo.of(field);
            if (fieldInfo == null) continue;
            String fieldName = fieldInfo.getName();
            FieldInfo conflictingFieldInfo = this.nameToFieldInfoMap.get(fieldName);
            Preconditions.checkArgument((conflictingFieldInfo == null ? 1 : 0) != 0, (String)"two fields have the same name <%s>: %s and %s", (Object[])new Object[]{fieldName, field, conflictingFieldInfo == null ? null : conflictingFieldInfo.getField()});
            this.nameToFieldInfoMap.put(fieldName, fieldInfo);
            nameSet.add(fieldName);
        }
        this.names = nameSet.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(nameSet));
    }
}

