/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.LogContent;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpResponse {
    private InputStream content;
    public final String contentEncoding;
    private long contentLength;
    public final String contentType;
    public final HttpHeaders headers;
    public final boolean isSuccessStatusCode;
    private LowLevelHttpResponse response;
    public final int statusCode;
    public final String statusMessage;
    public final HttpTransport transport;
    public boolean disableContentLogging;

    HttpResponse(HttpTransport transport, LowLevelHttpResponse response) {
        String message;
        int code;
        this.transport = transport;
        this.response = response;
        this.contentLength = response.getContentLength();
        this.contentType = response.getContentType();
        this.contentEncoding = response.getContentEncoding();
        this.statusCode = code = response.getStatusCode();
        this.isSuccessStatusCode = HttpResponse.isSuccessStatusCode(code);
        this.statusMessage = message = response.getReasonPhrase();
        Logger logger = HttpTransport.LOGGER;
        boolean loggable = logger.isLoggable(Level.CONFIG);
        StringBuilder logbuf = null;
        if (loggable) {
            logbuf = new StringBuilder();
            logbuf.append("-------------- RESPONSE --------------").append(Strings.LINE_SEPARATOR);
            String statusLine = response.getStatusLine();
            if (statusLine != null) {
                logbuf.append(statusLine);
            } else {
                logbuf.append(code);
                if (message != null) {
                    logbuf.append(' ').append(message);
                }
            }
            logbuf.append(Strings.LINE_SEPARATOR);
        }
        int size = response.getHeaderCount();
        Class<?> headersClass = ((Object)((Object)transport.defaultHeaders)).getClass();
        ClassInfo classInfo = ClassInfo.of(headersClass);
        HttpHeaders headers = this.headers = (HttpHeaders)((Object)ClassInfo.newInstance(headersClass));
        HashMap<String, String> fieldNameMap = HttpHeaders.getFieldNameMap(headersClass);
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo;
            String fieldName;
            String headerName = response.getHeaderName(i);
            String headerValue = response.getHeaderValue(i);
            if (loggable) {
                logbuf.append(headerName + ": " + headerValue).append(Strings.LINE_SEPARATOR);
            }
            if ((fieldName = fieldNameMap.get(headerName)) == null) {
                fieldName = headerName;
            }
            if ((fieldInfo = classInfo.getFieldInfo(fieldName)) != null) {
                Class type = fieldInfo.type;
                if (Collection.class.isAssignableFrom(type)) {
                    Collection collection = (Collection)fieldInfo.getValue((Object)headers);
                    if (collection == null) {
                        collection = ClassInfo.newCollectionInstance((Class)type);
                        fieldInfo.setValue((Object)headers, (Object)collection);
                    }
                    Class subFieldClass = ClassInfo.getCollectionParameter((Field)fieldInfo.field);
                    collection.add(FieldInfo.parsePrimitiveValue((Class)subFieldClass, (String)headerValue));
                    continue;
                }
                fieldInfo.setValue((Object)headers, FieldInfo.parsePrimitiveValue((Class)type, (String)headerValue));
                continue;
            }
            ArrayList<String> listValue = (ArrayList<String>)headers.get(fieldName);
            if (listValue == null) {
                listValue = new ArrayList<String>();
                headers.set(fieldName, listValue);
            }
            listValue.add(headerValue);
        }
        if (loggable) {
            logger.config(logbuf.toString());
        }
    }

    public InputStream getContent() throws IOException {
        LowLevelHttpResponse response = this.response;
        if (response == null) {
            return this.content;
        }
        InputStream content = this.response.getContent();
        this.response = null;
        if (content != null) {
            String contentEncoding;
            boolean loggable;
            byte[] debugContentByteArray = null;
            Logger logger = HttpTransport.LOGGER;
            boolean bl = loggable = !this.disableContentLogging && logger.isLoggable(Level.CONFIG) || logger.isLoggable(Level.ALL);
            if (loggable) {
                ByteArrayOutputStream debugStream = new ByteArrayOutputStream();
                InputStreamContent.copy(content, debugStream);
                debugContentByteArray = debugStream.toByteArray();
                content = new ByteArrayInputStream(debugContentByteArray);
                logger.config("Response size: " + debugContentByteArray.length + " bytes");
            }
            if ((contentEncoding = this.contentEncoding) != null && contentEncoding.contains("gzip")) {
                content = new GZIPInputStream(content);
                this.contentLength = -1L;
                if (loggable) {
                    ByteArrayOutputStream debugStream = new ByteArrayOutputStream();
                    InputStreamContent.copy(content, debugStream);
                    debugContentByteArray = debugStream.toByteArray();
                    content = new ByteArrayInputStream(debugContentByteArray);
                }
            }
            if (loggable) {
                String contentType = this.contentType;
                if (debugContentByteArray.length != 0 && contentType != null && LogContent.isTextBasedContentType(contentType)) {
                    logger.config(new String(debugContentByteArray));
                }
            }
            this.content = content;
        }
        return content;
    }

    public void ignore() throws IOException {
        InputStream content = this.getContent();
        if (content != null) {
            content.close();
        }
    }

    public HttpParser getParser() {
        return this.transport.getParser(this.contentType);
    }

    public <T> T parseAs(Class<T> dataClass) throws IOException {
        HttpParser parser = this.getParser();
        if (parser == null) {
            InputStream content = this.getContent();
            if (this.contentType == null) {
                if (content != null) {
                    throw new IllegalArgumentException("Missing Content-Type header in response: " + this.parseAsString());
                }
                return null;
            }
            throw new IllegalArgumentException("No parser defined for Content-Type: " + this.contentType);
        }
        return parser.parse(this, dataClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseAsString() throws IOException {
        InputStream content = this.getContent();
        if (content == null) {
            return "";
        }
        try {
            int bytesRead;
            long contentLength = this.contentLength;
            int bufferSize = contentLength == -1L ? 4096 : (int)contentLength;
            int length = 0;
            byte[] buffer = new byte[bufferSize];
            byte[] tmp = new byte[4096];
            while ((bytesRead = content.read(tmp)) != -1) {
                if (length + bytesRead > bufferSize) {
                    bufferSize = Math.max(bufferSize << 1, length + bytesRead);
                    byte[] newbuffer = new byte[bufferSize];
                    System.arraycopy(buffer, 0, newbuffer, 0, length);
                    buffer = newbuffer;
                }
                System.arraycopy(tmp, 0, buffer, length, bytesRead);
                length += bytesRead;
            }
            String string = new String(buffer, 0, length);
            return string;
        }
        finally {
            content.close();
        }
    }

    public static boolean isSuccessStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

