/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.media;

import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.googleapis.media.MediaHttpDownloaderProgressListener;
import com.google.api.client.googleapis.media.MediaHttpUploaderTest;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;

public class MediaHttpDownloaderTest
extends TestCase {
    private static final String TEST_REQUEST_URL = "http://www.test.com/request/url?alt=media";
    private static final int TEST_CHUNK_SIZE = 0x2000000;

    public void testDownloadOneCallHalfChunkSize() throws Exception {
        int contentLength = 0x1000000;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)contentLength, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDownloadOneCallMaxChunkSize() throws Exception {
        int contentLength = 0x2000000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
            MediaHttpDownloaderTest.assertEquals((int)0x2000000, (int)outputStream.size());
        }
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testSetBytesDownloaded() throws Exception {
        int contentLength = 0x2000000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.bytesDownloaded = contentLength - 10000;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.setBytesDownloaded((long)(contentLength - 10000));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)10000, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDownloadMultipleCallsMaxChunkSize() throws Exception {
        int contentLength = 0x6000000;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)contentLength, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)3, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDownloadProgressListener() throws Exception {
        int contentLength = 0x4000000;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.setProgressListener((MediaHttpDownloaderProgressListener)new ProgressListenerWithTwoDownloadCalls());
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
    }

    public void testDownloadServerErrorWithBackOffEnabled() throws Exception {
        int contentLength = 0x4000000;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testServerError = true;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, (HttpRequestInitializer)new MediaHttpUploaderTest.ZeroBackOffRequestInitializer());
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)3, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDownloadServerErrorWithBackOffDisabled() throws Exception {
        int contentLength = 0x4000000;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testServerError = true;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        try {
            downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
            MediaHttpDownloaderTest.fail((String)("Expected " + HttpResponseException.class));
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        MediaHttpDownloaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDownloadClientError() throws Exception {
        int contentLength = 0x4000000;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testClientError = true;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        try {
            downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
            MediaHttpDownloaderTest.fail((String)("Expected " + HttpResponseException.class));
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectMediaDownload() throws Exception {
        int contentLength = 0x2000000;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directDownloadEnabled = true;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.setDirectDownloadEnabled(true);
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)0x2000000, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testSetBytesDownloadedWithIllegalArguments() throws Exception {
        int contentLength = 0x2000000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        try {
            downloader.setBytesDownloaded(-1L);
            MediaHttpDownloaderTest.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        downloader.setBytesDownloaded(0L);
        downloader.setBytesDownloaded(1L);
    }

    public void testSetContentRangeWithIllegalArguments() throws Exception {
        int contentLength = 0x2000000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        try {
            downloader.setContentRange(-1L, 0);
            MediaHttpDownloaderTest.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            downloader.setContentRange(1L, 0);
            MediaHttpDownloaderTest.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            downloader.setContentRange(200L, 199);
            MediaHttpDownloaderTest.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        downloader.setContentRange(0L, 0);
        downloader.setContentRange(0L, 1);
        downloader.setContentRange(1L, 1);
        downloader.setContentRange(199L, 200);
        downloader.setContentRange(200L, 200);
    }

    public void testSetBytesDownloadedWithDirectDownload() throws Exception {
        int contentLength = 0x2000000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directDownloadEnabled = true;
        fakeTransport.bytesDownloaded = contentLength - 10000;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.setDirectDownloadEnabled(true);
        downloader.setBytesDownloaded((long)(contentLength - 10000));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)10000, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testSetBytesDownloadedWithDirectDownloadAndContentLengthNull() throws Exception {
        int contentLength = 0x2000000;
        MediaTransport fakeTransport = new MediaTransport(contentLength, false);
        fakeTransport.directDownloadEnabled = true;
        fakeTransport.bytesDownloaded = contentLength - 10000;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.setDirectDownloadEnabled(true);
        downloader.setBytesDownloaded((long)(contentLength - 10000));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)10000, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testSetContentRangeWithResumableDownload() throws Exception {
        int contentLength = 0x2000000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.bytesDownloaded = contentLength - 10000;
        fakeTransport.lastBytePos = contentLength;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.setContentRange((long)(contentLength - 10000), contentLength);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)10000, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testSetContentRangeFromStartWithResumableDownload() throws Exception {
        MediaTransport fakeTransport = new MediaTransport(0x2000000);
        fakeTransport.bytesDownloaded = 0;
        fakeTransport.lastBytePos = 1024;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.setContentRange(0L, 1024);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((long)1024L, (long)downloader.getLastBytePosition());
        MediaHttpDownloaderTest.assertEquals((int)1024, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testSetContentRangeFromMiddletWithResumableDownload() throws Exception {
        MediaTransport fakeTransport = new MediaTransport(0x2000000);
        fakeTransport.bytesDownloaded = 512;
        fakeTransport.lastBytePos = 1024;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.setContentRange(512L, 1024);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((long)1024L, (long)downloader.getLastBytePosition());
        MediaHttpDownloaderTest.assertEquals((int)512, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testSetContentRangeWithDirectDownload() throws Exception {
        int contentLength = 0x2000000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directDownloadEnabled = true;
        fakeTransport.bytesDownloaded = contentLength - 10000;
        fakeTransport.lastBytePos = contentLength;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        downloader.setDirectDownloadEnabled(true);
        downloader.setContentRange((long)(contentLength - 10000), contentLength);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)10000, (int)outputStream.size());
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectDownloadServerErrorWithBackOffEnabled() throws Exception {
        int contentLength = 0x4000000;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directDownloadEnabled = true;
        fakeTransport.testServerError = true;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, (HttpRequestInitializer)new MediaHttpUploaderTest.ZeroBackOffRequestInitializer());
        downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
        MediaHttpDownloaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectDownloadServerErrorWithBackOffDisabled() throws Exception {
        int contentLength = 0x4000000;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directDownloadEnabled = true;
        fakeTransport.testServerError = true;
        MediaHttpDownloader downloader = new MediaHttpDownloader((HttpTransport)fakeTransport, null);
        try {
            downloader.download(new GenericUrl(TEST_REQUEST_URL), (OutputStream)outputStream);
            MediaHttpDownloaderTest.fail((String)("Expected " + HttpResponseException.class));
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        MediaHttpDownloaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    private static class ProgressListenerWithTwoDownloadCalls
    implements MediaHttpDownloaderProgressListener {
        int progressListenerCalls;

        public void progressChanged(MediaHttpDownloader downloader) {
            ++this.progressListenerCalls;
            switch (downloader.getDownloadState()) {
                case MEDIA_IN_PROGRESS: {
                    TestCase.assertTrue((this.progressListenerCalls == 1 ? 1 : 0) != 0);
                    TestCase.assertEquals((Object)0.5, (Object)downloader.getProgress());
                    break;
                }
                case MEDIA_COMPLETE: {
                    TestCase.assertEquals((int)2, (int)this.progressListenerCalls);
                    TestCase.assertEquals((Object)1.0, (Object)downloader.getProgress());
                    break;
                }
            }
        }
    }

    private static class MediaTransport
    extends MockHttpTransport {
        int lowLevelExecCalls;
        int contentLength;
        int bytesDownloaded;
        int lastBytePos = -1;
        boolean testServerError;
        boolean testClientError;
        boolean directDownloadEnabled;
        boolean contentLengthIncluded;

        protected MediaTransport(int contentLength) {
            this.contentLength = contentLength;
            this.contentLengthIncluded = true;
        }

        protected MediaTransport(int contentLength, boolean contentLengthIncluded) {
            this.contentLength = contentLength;
            this.contentLengthIncluded = contentLengthIncluded;
        }

        public LowLevelHttpRequest buildRequest(String name, String url) {
            TestCase.assertEquals((String)MediaHttpDownloaderTest.TEST_REQUEST_URL, (String)url);
            return new MockLowLevelHttpRequest(){

                public LowLevelHttpResponse execute() {
                    ++MediaTransport.this.lowLevelExecCalls;
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    if (MediaTransport.this.directDownloadEnabled) {
                        if (MediaTransport.this.bytesDownloaded != 0) {
                            if (MediaTransport.this.lastBytePos == -1) {
                                TestCase.assertEquals((String)("bytes=" + MediaTransport.this.bytesDownloaded + "-"), (String)this.getFirstHeaderValue("Range"));
                            } else {
                                TestCase.assertEquals((String)("bytes=" + MediaTransport.this.bytesDownloaded + "-" + MediaTransport.this.lastBytePos), (String)this.getFirstHeaderValue("Range"));
                            }
                        }
                        if (MediaTransport.this.testServerError && MediaTransport.this.lowLevelExecCalls == 1) {
                            response.setStatusCode(500);
                            return response;
                        }
                        response.setStatusCode(200);
                        if (MediaTransport.this.contentLengthIncluded) {
                            response.addHeader("Content-Length", String.valueOf(MediaTransport.this.contentLength));
                        }
                        response.setContent((InputStream)new ByteArrayInputStream(new byte[MediaTransport.this.contentLength - MediaTransport.this.bytesDownloaded]));
                        return response;
                    }
                    long currentRequestLastBytePos = MediaTransport.this.bytesDownloaded + 0x2000000 - 1;
                    if (MediaTransport.this.lastBytePos != -1) {
                        currentRequestLastBytePos = Math.min((long)MediaTransport.this.lastBytePos, currentRequestLastBytePos);
                    }
                    TestCase.assertEquals((String)("bytes=" + MediaTransport.this.bytesDownloaded + "-" + currentRequestLastBytePos), (String)this.getFirstHeaderValue("Range"));
                    if (MediaTransport.this.testServerError && MediaTransport.this.lowLevelExecCalls == 2) {
                        response.setStatusCode(500);
                        return response;
                    }
                    if (MediaTransport.this.testClientError) {
                        response.setStatusCode(404);
                        return response;
                    }
                    response.setStatusCode(206);
                    int upper = MediaTransport.this.lastBytePos != -1 ? Math.min(MediaTransport.this.lastBytePos, MediaTransport.this.contentLength) - 1 : Math.min(MediaTransport.this.bytesDownloaded + 0x2000000, MediaTransport.this.contentLength) - 1;
                    response.addHeader("Content-Range", "bytes " + MediaTransport.this.bytesDownloaded + "-" + upper + "/" + MediaTransport.this.contentLength);
                    int bytesDownloadedCur = upper - MediaTransport.this.bytesDownloaded + 1;
                    response.setContent((InputStream)new ByteArrayInputStream(new byte[bytesDownloadedCur]));
                    MediaTransport.this.bytesDownloaded += bytesDownloadedCur;
                    return response;
                }
            };
        }
    }
}

