/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.subscriptions;

import com.google.api.client.googleapis.subscriptions.NotificationCallback;
import com.google.api.client.googleapis.subscriptions.Subscription;
import com.google.api.client.googleapis.subscriptions.TypedNotification;
import com.google.api.client.googleapis.subscriptions.UnparsedNotification;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypedNotificationCallback<T>
implements NotificationCallback {
    private Class<T> dataClass;

    public final Class<T> getDataClass() {
        return this.dataClass;
    }

    public TypedNotificationCallback<T> setDataType(Class<T> dataClass) {
        this.dataClass = (Class)Preconditions.checkNotNull(dataClass);
        return this;
    }

    protected abstract void handleNotification(Subscription var1, TypedNotification<T> var2) throws IOException;

    protected abstract ObjectParser getParser(UnparsedNotification var1) throws IOException;

    private Object parseContent(ObjectParser parser, UnparsedNotification notification) throws IOException {
        if (notification.getContentType() == null || Void.class.equals(this.dataClass)) {
            return null;
        }
        Charset charset = notification.getContentType() == null ? null : new HttpMediaType(notification.getContentType()).getCharsetParameter();
        return parser.parseAndClose(notification.getContent(), charset, this.dataClass);
    }

    @Override
    public void handleNotification(Subscription subscription, UnparsedNotification notification) throws IOException {
        ObjectParser parser = this.getParser(notification);
        Object content = this.parseContent(parser, notification);
        this.handleNotification(subscription, new TypedNotification<Object>(notification, content));
    }
}

