/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.subscriptions;

import com.google.api.client.googleapis.subscriptions.NotificationCallback;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public final class Subscription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final NotificationCallback notificationCallback;
    private final String clientToken;
    private String subscriptionExpires;
    private final String subscriptionId;
    private String topicId;

    public Subscription(NotificationCallback handler, String clientToken, String subscriptionId) {
        this.notificationCallback = (NotificationCallback)Preconditions.checkNotNull((Object)handler);
        this.clientToken = clientToken;
        this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId);
    }

    public Subscription processResponse(String subscriptionExpires, String topicId) {
        this.subscriptionExpires = subscriptionExpires;
        this.topicId = (String)Preconditions.checkNotNull((Object)topicId);
        return this;
    }

    public NotificationCallback getNotificationCallback() {
        return this.notificationCallback;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getSubscriptionExpires() {
        return this.subscriptionExpires;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public String toString() {
        return Objects.toStringHelper(Subscription.class).add("notificationCallback", (Object)this.notificationCallback).add("clientToken", (Object)this.clientToken).add("subscriptionExpires", (Object)this.subscriptionExpires).add("subscriptionID", (Object)this.subscriptionId).add("topicID", (Object)this.topicId).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Subscription)) {
            return false;
        }
        Subscription o = (Subscription)other;
        return this.subscriptionId.equals(o.subscriptionId);
    }

    public int hashCode() {
        return this.subscriptionId.hashCode();
    }
}

