/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.subscriptions;

import com.google.api.client.googleapis.subscriptions.Subscription;
import com.google.api.client.googleapis.subscriptions.SubscriptionHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.common.base.Preconditions;

public class SubscribeResponse {
    private final HttpResponse response;
    private final Subscription subscription;

    public SubscribeResponse(HttpResponse response, Subscription subscription) {
        this.response = (HttpResponse)Preconditions.checkNotNull((Object)response);
        this.subscription = subscription;
    }

    public final String getTopicId() {
        return SubscriptionHeaders.getTopicId(this.response.getHeaders());
    }

    public final String getTopicUri() {
        return SubscriptionHeaders.getTopicUri(this.response.getHeaders());
    }

    public final String getSubscriptionId() {
        return SubscriptionHeaders.getSubscriptionId(this.response.getHeaders());
    }

    public final String getSubscriptionExpires() {
        return SubscriptionHeaders.getSubscriptionExpires(this.response.getHeaders());
    }

    public final String getClientToken() {
        return SubscriptionHeaders.getClientToken(this.response.getHeaders());
    }

    public final HttpResponse getHttpResponse() {
        return this.response;
    }

    public final Subscription getSubscription() {
        return this.subscription;
    }
}

