/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.subscriptions;

import com.google.api.client.googleapis.subscriptions.Subscription;
import com.google.api.client.googleapis.subscriptions.SubscriptionStore;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemorySubscriptionStore
implements SubscriptionStore {
    private final Lock lock = new ReentrantLock();
    private final SortedMap<String, Subscription> storedSubscriptions = new TreeMap<String, Subscription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSubscription(Subscription subscription) {
        this.lock.lock();
        try {
            this.storedSubscriptions.put(subscription.getSubscriptionId(), subscription);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(Subscription subscription) {
        this.lock.lock();
        try {
            this.storedSubscriptions.remove(subscription.getSubscriptionId());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Subscription> listSubscriptions() {
        this.lock.lock();
        try {
            Collection<Subscription> collection = Collections.unmodifiableCollection(this.storedSubscriptions.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription getSubscription(String subscriptionId) {
        this.lock.lock();
        try {
            Subscription subscription = (Subscription)this.storedSubscriptions.get(subscriptionId);
            return subscription;
        }
        finally {
            this.lock.unlock();
        }
    }
}

