/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.android.accounts;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import com.google.api.client.util.Preconditions;

public final class GoogleAccountManager {
    public static final String ACCOUNT_TYPE = "com.google";
    private final AccountManager manager;

    public GoogleAccountManager(AccountManager accountManager) {
        this.manager = (AccountManager)Preconditions.checkNotNull((Object)accountManager);
    }

    public GoogleAccountManager(Context context) {
        this(AccountManager.get((Context)context));
    }

    public AccountManager getAccountManager() {
        return this.manager;
    }

    public Account[] getAccounts() {
        return this.manager.getAccountsByType(ACCOUNT_TYPE);
    }

    public Account getAccountByName(String accountName) {
        if (accountName != null) {
            for (Account account : this.getAccounts()) {
                if (!accountName.equals(account.name)) continue;
                return account;
            }
        }
        return null;
    }

    public void invalidateAuthToken(String authToken) {
        this.manager.invalidateAuthToken(ACCOUNT_TYPE, authToken);
    }
}

