/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.logging;

import com.google.ads.googleads.lib.logging.Event;
import com.google.ads.googleads.lib.logging.RequestLogger;
import com.google.ads.googleads.lib.logging.scrub.LogScrubber;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LoggingInterceptor
implements ClientInterceptor {
    public static final Metadata.Key<String> REQUEST_ID_HEADER_KEY = Metadata.Key.of((String)"request-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final ImmutableSet<CharSequence> HEADERS_TO_SCRUB = ImmutableSet.of((Object)"developer-token", (Object)"authorization");
    private static final Logger thisClassLogger = LoggerFactory.getLogger(LoggingInterceptor.class);
    private final LogScrubber LOG_SCRUBBER = LogScrubber.getInstance();
    private final RequestLogger requestLogger;
    private final ImmutableMap<String, String> requestHeaders;
    private final ImmutableMap<String, String> scrubbedRequestHeaders;
    private final String endpoint;

    public LoggingInterceptor(RequestLogger requestLogger, ImmutableMap<String, String> headers, String endpoint) {
        this.requestLogger = requestLogger;
        this.requestHeaders = headers;
        this.scrubbedRequestHeaders = LoggingInterceptor.scrubHeaders(this.requestHeaders);
        this.endpoint = endpoint;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall wrappedCall = next.newCall(method, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(wrappedCall){
            private volatile ReqT request;
            private volatile RespT response;
            private volatile Metadata responseHeaders;

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onMessage(RespT message) {
                        super.onMessage(message);
                        response = message;
                    }

                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                        responseHeaders = headers;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClose(Status status, Metadata trailers) {
                        try {
                            Object scrubbedRequest = LoggingInterceptor.this.LOG_SCRUBBER.edit(request);
                            Object scrubbedResponse = LoggingInterceptor.this.LOG_SCRUBBER.edit(response);
                            LoggingInterceptor.this.logSummary(status, scrubbedRequest, method, responseHeaders, trailers);
                            LoggingInterceptor.this.logDetail(status, method, (ImmutableMap<String, String>)LoggingInterceptor.this.requestHeaders, LoggingInterceptor.this.endpoint, scrubbedRequest, responseHeaders, trailers, scrubbedResponse);
                        }
                        catch (Throwable ex) {
                            thisClassLogger.warn("Failed to log request.", ex);
                        }
                        finally {
                            request = null;
                            response = null;
                            responseHeaders = null;
                            super.onClose(status, trailers);
                        }
                    }
                }, headers);
            }

            public void sendMessage(ReqT message) {
                super.sendMessage(message);
                this.request = message;
            }
        };
    }

    private static ImmutableMap<String, String> scrubHeaders(ImmutableMap<String, String> headers) {
        LinkedHashMap<String, String> scrubbed = new LinkedHashMap<String, String>();
        if (headers != null) {
            scrubbed.putAll((Map<String, String>)headers);
            scrubbed.replaceAll((key, value) -> HEADERS_TO_SCRUB.contains(key) ? "REDACTED" : value);
        }
        return ImmutableMap.copyOf(scrubbed);
    }

    private static Level getDetailLevel(Status status) {
        return LoggingInterceptor.isSuccess(status) ? Level.DEBUG : Level.INFO;
    }

    private static Level getSummaryLevel(Status status) {
        return LoggingInterceptor.isSuccess(status) ? Level.INFO : Level.WARN;
    }

    private static String getRequestId(Metadata responseHeaders, Metadata responseTrailers) {
        if (responseHeaders != null && responseHeaders.containsKey(REQUEST_ID_HEADER_KEY)) {
            return (String)responseHeaders.get(REQUEST_ID_HEADER_KEY);
        }
        if (responseTrailers != null && responseTrailers.containsKey(REQUEST_ID_HEADER_KEY)) {
            return (String)responseTrailers.get(REQUEST_ID_HEADER_KEY);
        }
        return null;
    }

    private static String getCustomerId(Object request) {
        Optional<Method> getter = Stream.of(request.getClass().getMethods()).filter(method -> method.getName().equals("getCustomerId")).findFirst();
        if (!getter.isPresent()) {
            getter = Stream.of(request.getClass().getMethods()).filter(method -> method.getName().equals("getResourceName")).findFirst();
        }
        if (getter.isPresent()) {
            try {
                return (String)getter.get().invoke(request, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                thisClassLogger.error("Unable to retrieve customer ID from " + request);
            }
        }
        return null;
    }

    private static <ReqT, RespT> String getMethodName(MethodDescriptor<ReqT, RespT> method) {
        return method == null ? null : method.getFullMethodName();
    }

    private static boolean isSuccess(Status status) {
        return status != null && status.isOk();
    }

    private void logDetail(Status responseStatus, MethodDescriptor method, ImmutableMap<String, String> requestHeaders, String endpoint, Object request, Metadata responseHeaders, Metadata responseTrailers, Object response) {
        Level level = LoggingInterceptor.getDetailLevel(responseStatus);
        if (this.requestLogger.isDetailEnabled(level)) {
            String methodName = LoggingInterceptor.getMethodName(method);
            boolean isSuccess = LoggingInterceptor.isSuccess(responseStatus);
            Event.Detail event = Event.Detail.builder().setResponseStatus(responseStatus).setSuccess(isSuccess).setMethodName(methodName).setRawRequestHeaders((Map<String, String>)requestHeaders).setScrubbedRequestHeaders((Map<String, String>)this.scrubbedRequestHeaders).setEndpoint(endpoint).setRequest(request).setResponseHeaderMetadata(responseHeaders).setResponseTrailerMetadata(responseTrailers).setResponse(response).build();
            this.requestLogger.logDetail(level, event);
        }
    }

    private void logSummary(Status responseStatus, Object request, MethodDescriptor method, Metadata responseHeaders, Metadata responseTrailers) {
        Level level = LoggingInterceptor.getSummaryLevel(responseStatus);
        if (this.requestLogger.isSummaryEnabled(level)) {
            String customerId = LoggingInterceptor.getCustomerId(request);
            String requestId = LoggingInterceptor.getRequestId(responseHeaders, responseTrailers);
            String methodName = LoggingInterceptor.getMethodName(method);
            boolean isSuccess = LoggingInterceptor.isSuccess(responseStatus);
            Event.Summary event = Event.Summary.builder().setResponseStatus(responseStatus).setSuccess(isSuccess).setMethodName(methodName).setCustomerId(customerId).setEndpoint(this.endpoint).setRequestId(requestId).build();
            this.requestLogger.logSummary(level, event);
        }
    }
}

