/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.axis;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.dfp.lib.client.DfpServiceDescriptor;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.api.ads.dfp.lib.conf.DfpApiConfiguration;
import com.google.api.ads.dfp.lib.soap.DfpHttpHeaderHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfpAxisHeaderHandler
implements HeaderHandler<DfpSession, DfpServiceDescriptor> {
    private final SoapClientHandlerInterface<Object> soapClientHandler;
    private final DfpApiConfiguration dfpApiConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final DfpHttpHeaderHandler dfpHttpHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;

    @Inject
    public DfpAxisHeaderHandler(SoapClientHandlerInterface soapClientHandler, DfpApiConfiguration dfpApiConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, DfpHttpHeaderHandler dfpHttpHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.dfpApiConfiguration = dfpApiConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.dfpHttpHeaderHandler = dfpHttpHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, DfpSession dfpSession, DfpServiceDescriptor dfpServiceDescriptor) throws AuthenticationException, ServiceException {
        try {
            this.dfpHttpHeaderHandler.setHttpHeaders(soapClient, dfpSession);
            Object soapHeader = this.createSoapHeader(dfpServiceDescriptor);
            BeanUtils.setProperty((Object)soapHeader, (String)"applicationName", (Object)this.userAgentCombiner.getUserAgent(dfpSession.getApplicationName()));
            if (dfpSession.getNetworkCode() != null) {
                BeanUtils.setProperty((Object)soapHeader, (String)"networkCode", (Object)dfpSession.getNetworkCode());
            }
            this.setAuthenticationHeaders(dfpServiceDescriptor, soapClient, soapHeader, dfpSession);
            String namespace = String.valueOf(this.dfpApiConfiguration.getNamespacePrefix()) + "/" + dfpServiceDescriptor.getVersion();
            this.soapClientHandler.setHeader(soapClient, namespace, "RequestHeader", soapHeader);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }

    @VisibleForTesting
    void setAuthenticationHeaders(DfpServiceDescriptor dfpServiceDescriptor, Object soapClient, Object soapHeader, DfpSession dfpSession) throws AuthenticationException {
        if (dfpSession.getClientLoginToken() != null) {
            try {
                BeanUtils.setProperty((Object)soapHeader, (String)"authentication", (Object)this.createClientLoginObject(dfpServiceDescriptor, dfpSession));
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Could not set the header.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not set the header.", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not set the header.", e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Could not set the header.", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Could not set the header.", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not set the header.", e);
            }
        } else {
            this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)dfpSession);
        }
    }

    @VisibleForTesting
    Object createSoapHeader(DfpServiceDescriptor adsServiceDescriptor) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(String.valueOf(adsServiceDescriptor.getInterfaceClass().getPackage().getName()) + ".SoapRequestHeader").newInstance();
    }

    @VisibleForTesting
    Object createClientLoginObject(DfpServiceDescriptor dfpServiceDescriptor, DfpSession dfpSession) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        Class interfaceClass = dfpServiceDescriptor.getInterfaceClass();
        String packageName = interfaceClass.getPackage().getName();
        Class<?> clientLoginClass = Class.forName(String.valueOf(packageName) + "." + "ClientLogin");
        return clientLoginClass.getConstructor(String.class, String.class).newInstance(null, dfpSession.getClientLoginToken());
    }
}

