/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.axis.utils.v201201;

import com.google.api.ads.dfp.axis.v201201.BooleanValue;
import com.google.api.ads.dfp.axis.v201201.ColumnType;
import com.google.api.ads.dfp.axis.v201201.DateTime;
import com.google.api.ads.dfp.axis.v201201.DateTimeValue;
import com.google.api.ads.dfp.axis.v201201.NumberValue;
import com.google.api.ads.dfp.axis.v201201.ResultSet;
import com.google.api.ads.dfp.axis.v201201.Row;
import com.google.api.ads.dfp.axis.v201201.TextValue;
import com.google.api.ads.dfp.axis.v201201.Value;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pql {
    private Pql() {
    }

    public static Value createValue(Object value) {
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value == null) {
            return new TextValue();
        }
        if (value instanceof Boolean) {
            BooleanValue booleanValue = new BooleanValue();
            booleanValue.setValue((Boolean)value);
            return booleanValue;
        }
        if (value instanceof Double || value instanceof Long || value instanceof Integer) {
            NumberValue numberValue = new NumberValue();
            numberValue.setValue(value.toString());
            return numberValue;
        }
        if (value instanceof String) {
            TextValue textValue = new TextValue();
            textValue.setValue((String)value);
            return textValue;
        }
        if (value instanceof DateTime) {
            DateTimeValue dateTimeValue = new DateTimeValue();
            dateTimeValue.setValue((DateTime)value);
            return dateTimeValue;
        }
        throw new IllegalArgumentException("Unsupported Value type [" + value.getClass() + "]");
    }

    public static List<String[]> resultSetToStringArrayList(ResultSet resultSet) {
        List stringArrayList = Lists.newArrayList();
        stringArrayList.add(Pql.getColumnLabels(resultSet));
        if (resultSet.getRows() != null) {
            Row[] rowArray = resultSet.getRows();
            int n = rowArray.length;
            int n2 = 0;
            while (n2 < n) {
                Row row = rowArray[n2];
                try {
                    stringArrayList.add(Pql.getRowStringValues(row));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Cannot convert result set to string array list", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Cannot convert result set to string array list", e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Cannot convert result set to string array list: " + e.getMessage(), e.getTargetException());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Cannot convert result set to string array list", e);
                }
                ++n2;
            }
        }
        return stringArrayList;
    }

    public static String resultSetToString(ResultSet resultSet) throws IllegalAccessException {
        StringBuilder resultSetStringBuilder = new StringBuilder();
        List<String[]> resultSetStringArrayList = Pql.resultSetToStringArrayList(resultSet);
        List<Integer> maxColumnSizes = Pql.getMaxColumnSizes(resultSetStringArrayList);
        String rowTemplate = Pql.createRowTemplate(maxColumnSizes);
        String rowSeparator = Pql.createRowSeperator(maxColumnSizes);
        resultSetStringBuilder.append(rowSeparator);
        int i = 0;
        while (i < resultSetStringArrayList.size()) {
            resultSetStringBuilder.append(String.format(rowTemplate, resultSetStringArrayList.get(i))).append(rowSeparator);
            ++i;
        }
        return resultSetStringBuilder.toString();
    }

    private static String createRowTemplate(List<Integer> maxColumnSizes) {
        List columnFormatSpecifiers = Lists.newArrayList();
        for (int maxColumnSize : maxColumnSizes) {
            columnFormatSpecifiers.add("%-" + maxColumnSize + "s");
        }
        return "| " + Joiner.on((String)" | ").join((Iterable)columnFormatSpecifiers) + " |\n";
    }

    private static String createRowSeperator(List<Integer> maxColumnSizes) {
        StringBuilder rowSeparator = new StringBuilder("+");
        for (int maxColumnSize : maxColumnSizes) {
            rowSeparator.append(Strings.repeat((String)"-", (int)(maxColumnSize + 2))).append("+");
        }
        return rowSeparator.append("\n").toString();
    }

    private static List<Integer> getMaxColumnSizes(List<String[]> resultSet) {
        List maxColumnSizes = Lists.newArrayList();
        int i = 0;
        while (i < resultSet.get(0).length) {
            int maxColumnSize = -1;
            int j = 0;
            while (j < resultSet.size()) {
                if (resultSet.get(j)[i].length() > maxColumnSize) {
                    maxColumnSize = resultSet.get(j)[i].length();
                }
                ++j;
            }
            maxColumnSizes.add(maxColumnSize);
            ++i;
        }
        return maxColumnSizes;
    }

    public static String[] getColumnLabels(ResultSet resultSet) {
        List columnLabels = Lists.newArrayList();
        ColumnType[] columnTypeArray = resultSet.getColumnTypes();
        int n = columnTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnType column = columnTypeArray[n2];
            columnLabels.add(column.getLabelName());
            ++n2;
        }
        return columnLabels.toArray(new String[0]);
    }

    public static Object[] getRowValues(Row row) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List rowValues = Lists.newArrayList();
        Value[] valueArray = row.getValues();
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            rowValues.add(BeanUtils.getProperty((Object)value, (String)"value"));
            ++n2;
        }
        return rowValues.toArray(new Object[0]);
    }

    public static String[] getRowStringValues(Row row) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] rowValues = Pql.getRowValues(row);
        List rowStringValues = Lists.newArrayList();
        Object[] objectArray = rowValues;
        int n = rowValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                rowStringValues.add(obj.toString());
            } else {
                rowStringValues.add("");
            }
            ++n2;
        }
        return rowStringValues.toArray(new String[0]);
    }
}

