/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.jaxws;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.dfp.lib.client.DfpServiceDescriptor;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.api.ads.dfp.lib.conf.DfpApiConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfpJaxWsHeaderHandler
implements HeaderHandler<DfpSession, DfpServiceDescriptor> {
    private static final String REQUEST_HEADER_LOCAL_PART = "RequestHeader";
    private final SoapClientHandlerInterface<Object> soapClientHandler;
    private final DfpApiConfiguration dfpApiConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;

    @Inject
    public DfpJaxWsHeaderHandler(SoapClientHandlerInterface soapClientHandler, DfpApiConfiguration dfpApiConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.dfpApiConfiguration = dfpApiConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, DfpSession dfpSession, DfpServiceDescriptor dfpServiceDescriptor) throws AuthenticationException, ServiceException {
        Map<String, Object> headerData = this.readHeaderElements(dfpSession);
        this.setAuthenticationHeaders(soapClient, headerData, dfpSession);
        this.soapClientHandler.setHeader(soapClient, null, null, (Object)this.constructSoapHeader(headerData, dfpServiceDescriptor));
    }

    @VisibleForTesting
    void setAuthenticationHeaders(Object soapClient, Map<String, Object> headerElements, DfpSession dfpSession) throws AuthenticationException {
        if (dfpSession.getClientLoginToken() != null) {
            headerElements.put("authentication", dfpSession.getClientLoginToken());
        } else {
            this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)dfpSession);
        }
    }

    private Map<String, Object> readHeaderElements(DfpSession dfpSession) {
        HashMap mapToFill = Maps.newHashMap();
        mapToFill.put("networkCode", dfpSession.getNetworkCode());
        mapToFill.put("applicationName", this.userAgentCombiner.getUserAgent(dfpSession.getApplicationName()));
        return mapToFill;
    }

    private SOAPElement constructSoapHeader(Map<String, Object> headerData, DfpServiceDescriptor dfpServiceDescriptor) {
        String requestHeaderNamespace = String.valueOf(this.dfpApiConfiguration.getNamespacePrefix()) + "/" + dfpServiceDescriptor.getVersion();
        try {
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            SOAPElement requestHeader = soapFactory.createElement(REQUEST_HEADER_LOCAL_PART, "ns1", requestHeaderNamespace);
            for (String headerElementName : headerData.keySet()) {
                if (headerData.get(headerElementName) == null) continue;
                SOAPElement newElement = requestHeader.addChildElement(headerElementName, "ns1", requestHeaderNamespace);
                if (headerElementName.equals("authentication")) {
                    Name xsiTypeString = soapFactory.createName("type", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    newElement.addAttribute(xsiTypeString, "ns1:ClientLogin");
                    SOAPElement tokenElement = newElement.addChildElement("token", "ns1", requestHeaderNamespace);
                    tokenElement.addTextNode(headerData.get(headerElementName).toString());
                    continue;
                }
                newElement.addTextNode(headerData.get(headerElementName).toString());
            }
            return requestHeader;
        }
        catch (SOAPException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }
}

