/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201802.shopping;

import com.google.api.ads.adwords.axis.utils.v201802.shopping.ProductPartitionNode;
import com.google.api.ads.adwords.axis.v201802.cm.ProductDimension;
import java.util.Comparator;
import java.util.Objects;

class ProductPartitionNodeDiffer {
    private ProductPartitionNodeDiffer() {
    }

    static NodeDifference diff(ProductPartitionNode originalNode, ProductPartitionNode newNode, Comparator<ProductDimension> dimensionComparator) {
        NodeDifference nodeDifference;
        if (originalNode == null && newNode == null) {
            nodeDifference = NodeDifference.NONE;
        } else if (originalNode == null) {
            nodeDifference = NodeDifference.NEW_NODE;
        } else if (newNode == null) {
            nodeDifference = NodeDifference.REMOVED_NODE;
        } else {
            if (dimensionComparator.compare(originalNode.getDimension(), newNode.getDimension()) != 0) {
                throw new IllegalArgumentException("Original node and new node are not for the same product dimension");
            }
            if (originalNode.isUnit() != newNode.isUnit()) {
                nodeDifference = NodeDifference.PARTITION_TYPE_CHANGE;
            } else if (originalNode.isExcludedUnit() != newNode.isExcludedUnit()) {
                nodeDifference = NodeDifference.EXCLUDED_UNIT_CHANGE;
            } else if (!originalNode.isExcludedUnit() && originalNode.isUnit() && newNode.isUnit()) {
                nodeDifference = NodeDifference.NONE;
                if (!Objects.equals(originalNode.getBid(), newNode.getBid())) {
                    nodeDifference = NodeDifference.BIDDABLE_UNIT_CHANGE;
                }
                if (!Objects.equals(originalNode.getTrackingUrlTemplate(), newNode.getTrackingUrlTemplate())) {
                    nodeDifference = NodeDifference.BIDDABLE_UNIT_CHANGE;
                }
                if (!Objects.equals(originalNode.getCustomParameters(), newNode.getCustomParameters())) {
                    nodeDifference = NodeDifference.BIDDABLE_UNIT_CHANGE;
                }
            } else {
                nodeDifference = NodeDifference.NONE;
            }
        }
        return nodeDifference;
    }

    static enum NodeDifference {
        NONE,
        NEW_NODE,
        REMOVED_NODE,
        PARTITION_TYPE_CHANGE,
        EXCLUDED_UNIT_CHANGE,
        BIDDABLE_UNIT_CHANGE;

    }
}

