/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public final class Media {
    private Media() {
    }

    public static byte[] getMediaDataFromFile(String fileName) throws IOException {
        return Media.getMediaDataFromFile(new File(fileName));
    }

    public static byte[] getMediaDataFromFile(File file) throws IOException {
        return Media.getByteArrayFromStream(new FileInputStream(file));
    }

    public static byte[] getMediaDataFromUrl(String url) throws IOException {
        return Media.getMediaDataFromUrl(new URL(url));
    }

    public static byte[] getMediaDataFromUrl(URL url) throws IOException {
        return Media.getByteArrayFromStream(url.openStream());
    }

    private static byte[] getByteArrayFromStream(final InputStream inputStream) throws IOException {
        return new ByteSource(){

            public InputStream openStream() {
                return inputStream;
            }
        }.read();
    }

    public static void saveMediaDataToFile(byte[] mediaData, String fileName) throws FileNotFoundException, IOException {
        Media.saveMediaDataToFile(mediaData, new File(fileName));
    }

    public static void saveMediaDataToFile(byte[] mediaData, File file) throws FileNotFoundException, IOException {
        Media.writeBytesToStream(mediaData, new FileOutputStream(file));
    }

    @VisibleForTesting
    static void writeBytesToStream(byte[] bytes, final OutputStream outputStream) throws IOException {
        new ByteSink(){

            public OutputStream openStream() {
                return outputStream;
            }
        }.write(bytes);
    }
}

