/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils.logging;

import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinter;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinterInterface;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingModule
extends AbstractModule {
    private final String loggerPrefix;

    public LoggingModule(String loggerPrefix) {
        this.loggerPrefix = loggerPrefix;
    }

    protected void configure() {
        this.bind(AdsServiceLoggers.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<DocumentBuilder>>(){}).to(DocumentBuilderSupplier.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Transformer>>(){}).to(TransformerSupplier.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<XPath>>(){}).to(XPathSupplier.class);
        this.bind(PrettyPrinterInterface.class).to(PrettyPrinter.class);
        this.bind(Logger.class).annotatedWith((Annotation)Names.named((String)"libLogger")).toInstance((Object)AdsServiceLoggers.ADS_API_LIB_LOG);
        this.configureLogger(this.loggerPrefix, "soapXmlLogger");
        this.configureLogger(this.loggerPrefix, "requestInfoLogger");
    }

    protected void configureLogger(String prefix, String name) {
        this.bind(Logger.class).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new LoggerProvider(prefix, name)).asEagerSingleton();
    }

    private static final class LoggerProvider
    implements Provider<Logger> {
        private final String loggerPrefix;
        private final String logType;

        public LoggerProvider(String loggerPrefix, String logType) {
            this.loggerPrefix = loggerPrefix;
            this.logType = logType;
        }

        public Logger get() {
            return LoggerFactory.getLogger((String)(this.loggerPrefix + "." + this.logType));
        }
    }

    @ThreadSafe
    @VisibleForTesting
    static final class TransformerSupplier
    implements Supplier<Transformer> {
        TransformerSupplier() {
        }

        public Transformer get() {
            Transformer transformer;
            TransformerFactory factory;
            try {
                factory = TransformerFactory.newInstance();
            }
            catch (TransformerFactoryConfigurationError e) {
                AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to instantiate a TransformerFactory. Error: ", (Throwable)e);
                return null;
            }
            try {
                transformer = factory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to obtain a new Transformer. Error: ", (Throwable)e);
                return null;
            }
            if (transformer == null) {
                AdsServiceLoggers.ADS_API_LIB_LOG.warn("TransformerFactory returned a null instance.");
                return null;
            }
            try {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            catch (IllegalArgumentException e) {
                AdsServiceLoggers.ADS_API_LIB_LOG.debug("[NON-CRITICAL] XML in log messages may not be indented properly because Transformer implementation does not support one or more indent options.", (Throwable)e);
            }
            return transformer;
        }
    }

    @ThreadSafe
    @VisibleForTesting
    static final class DocumentBuilderSupplier
    implements Supplier<DocumentBuilder> {
        DocumentBuilderSupplier() {
        }

        public DocumentBuilder get() {
            DocumentBuilderFactory factory;
            try {
                factory = DocumentBuilderFactory.newInstance();
            }
            catch (FactoryConfigurationError e) {
                AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to instantiate a DocumentBuilderFactory. Error: " + e);
                return null;
            }
            try {
                return factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                AdsServiceLoggers.ADS_API_LIB_LOG.warn("Unable to obtain a new DocumentBuilder. Error: " + e);
                return null;
            }
        }
    }

    @ThreadSafe
    private static final class XPathSupplier
    implements Supplier<XPath> {
        private XPathSupplier() {
        }

        public XPath get() {
            return XPathFactory.newInstance().newXPath();
        }
    }
}

