/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.logging;

import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.common.lib.client.RemoteCallReturn;
import com.google.api.ads.common.lib.client.RequestInfo;
import com.google.api.ads.common.lib.client.ResponseInfo;
import com.google.api.ads.common.lib.utils.logging.RemoteCallLoggerDelegate;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.Data;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.inject.name.Named;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;

public class ReportServiceLogger {
    @VisibleForTesting
    static final Set<String> SCRUBBED_HEADERS = Sets.newHashSet((Object[])new String[]{"authorization", "authtoken", "password", "developertoken"});
    @VisibleForTesting
    static final String REDACTED_HEADER = "REDACTED";
    @VisibleForTesting
    static final String REDACTED_REPORT_DATA = "REDACTED REPORT DATA";
    private static final String CLIENT_CUSTOMER_ID = "clientCustomerId";
    private final RemoteCallLoggerDelegate loggerDelegate;

    @Inject
    private ReportServiceLogger(@Named(value="report_download") Logger reportLogger) {
        this(new RemoteCallLoggerDelegate(reportLogger, reportLogger, null, RemoteCallLoggerDelegate.RemoteCallType.HTTP));
    }

    ReportServiceLogger(RemoteCallLoggerDelegate remoteCallLoggerDelegate) {
        this.loggerDelegate = remoteCallLoggerDelegate;
    }

    public void logRequest(@Nullable HttpRequest request, int statusCode, @Nullable String statusMessage) {
        boolean isSuccess = HttpStatusCodes.isSuccess((int)statusCode);
        if (!this.loggerDelegate.isSummaryLoggable(isSuccess) && !this.loggerDelegate.isDetailsLoggable(isSuccess)) {
            return;
        }
        RequestInfo requestInfo = this.buildRequestInfo(request);
        ResponseInfo responseInfo = this.buildResponseInfo(request, statusCode, statusMessage);
        RemoteCallReturn.Builder remoteCallReturnBuilder = new RemoteCallReturn.Builder().withRequestInfo(requestInfo).withResponseInfo(responseInfo);
        if (!isSuccess) {
            remoteCallReturnBuilder.withException(new ReportException(String.format("%s: %s", statusCode, statusMessage)));
        }
        RemoteCallReturn remoteCallReturn = remoteCallReturnBuilder.build();
        this.loggerDelegate.logRequestSummary(remoteCallReturn);
        this.loggerDelegate.logRequestDetails(remoteCallReturn);
    }

    @VisibleForTesting
    RequestInfo buildRequestInfo(HttpRequest request) {
        RequestInfo.Builder requestBuilder = new RequestInfo.Builder();
        if (request != null) {
            requestBuilder.withServiceName("reportdownload").withMethodName(request.getRequestMethod());
            try {
                requestBuilder.withUrl(request.getUrl().toURL().toString());
            }
            catch (IllegalArgumentException e) {
                requestBuilder.withUrl("Malformed URL: " + request.getUrl());
            }
            if (request.getHeaders() != null) {
                String clientCustomerId = request.getHeaders().getFirstHeaderStringValue(CLIENT_CUSTOMER_ID);
                requestBuilder.withContext(CLIENT_CUSTOMER_ID, clientCustomerId);
            }
            requestBuilder.withPayload(this.extractPayload(request.getHeaders(), request.getContent()));
        }
        return requestBuilder.build();
    }

    @VisibleForTesting
    ResponseInfo buildResponseInfo(HttpRequest request, int statusCode, String statusMessage) {
        ResponseInfo.Builder responseBuilder = new ResponseInfo.Builder();
        StringBuilder payloadBuilder = new StringBuilder();
        payloadBuilder.append(String.format("%d %s%n", statusCode, statusMessage));
        this.appendMapAsString(payloadBuilder, (Map<String, Object>)request.getResponseHeaders());
        payloadBuilder.append(String.format("%nContent:%n%s", REDACTED_REPORT_DATA));
        return responseBuilder.withPayload(payloadBuilder.toString()).build();
    }

    private String extractPayload(HttpHeaders headers, @Nullable HttpContent content) {
        StringBuilder messageBuilder = new StringBuilder();
        if (headers != null) {
            this.appendMapAsString(messageBuilder, (Map<String, Object>)headers);
        }
        if (content != null) {
            messageBuilder.append(String.format("%nContent:%n", new Object[0]));
            if (content instanceof UrlEncodedContent) {
                UrlEncodedContent encodedContent = (UrlEncodedContent)content;
                this.appendMapAsString(messageBuilder, Data.mapOf((Object)encodedContent.getData()));
            } else if (content != null) {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                try {
                    content.writeTo((OutputStream)byteStream);
                    messageBuilder.append(byteStream.toString(StandardCharsets.UTF_8.name()));
                }
                catch (IOException e) {
                    messageBuilder.append("Unable to read request content due to exception: " + e);
                }
            }
        }
        return messageBuilder.toString();
    }

    private StringBuilder appendMapAsString(StringBuilder messageBuilder, Map<String, Object> map) {
        for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
            Object headerValue = mapEntry.getValue();
            if (SCRUBBED_HEADERS.contains(mapEntry.getKey().toLowerCase())) {
                headerValue = REDACTED_HEADER;
            }
            messageBuilder.append(String.format("%s: %s%n", mapEntry.getKey(), headerValue));
        }
        return messageBuilder;
    }
}

