/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.lib.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.beanutils.PropertyUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimesHelper<T, D> {
    private static final String DATE_PATTERN = "%04d-%02d-%02d";
    private Class<T> dateTimeClass;
    private Class<D> dateClass;

    public DateTimesHelper(Class<T> dateTimeClass, Class<D> dateClass) {
        this.dateTimeClass = dateTimeClass;
        this.dateClass = dateClass;
    }

    public T toDateTime(Calendar calendar) {
        return this.toDateTime(new DateTime((Object)calendar));
    }

    public T toDateTime(Instant instant, String timeZoneId) {
        return this.toDateTime(instant.toDateTime(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timeZoneId))));
    }

    public T toDateTime(DateTime dateTime) {
        try {
            D dateObj = this.dateClass.newInstance();
            PropertyUtils.setProperty(dateObj, (String)"year", (Object)dateTime.getYear());
            PropertyUtils.setProperty(dateObj, (String)"month", (Object)dateTime.getMonthOfYear());
            PropertyUtils.setProperty(dateObj, (String)"day", (Object)dateTime.getDayOfMonth());
            T dateTimeObj = this.dateTimeClass.newInstance();
            PropertyUtils.setProperty(dateTimeObj, (String)"date", dateObj);
            PropertyUtils.setProperty(dateTimeObj, (String)"hour", (Object)dateTime.getHourOfDay());
            PropertyUtils.setProperty(dateTimeObj, (String)"minute", (Object)dateTime.getMinuteOfHour());
            PropertyUtils.setProperty(dateTimeObj, (String)"second", (Object)dateTime.getSecondOfMinute());
            PropertyUtils.setProperty(dateTimeObj, (String)"timeZoneID", (Object)dateTime.getZone().toTimeZone().getID());
            return dateTimeObj;
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instantiate class.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not instantiate class.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Could not set field.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not set field.", e);
        }
    }

    public T toDateTime(String dateTime, String timeZoneId) {
        return this.toDateTime(ISODateTimeFormat.dateHourMinuteSecond().parseDateTime(dateTime).withZoneRetainFields(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timeZoneId))));
    }

    public T toDateTimeWithTimeZone(String dateTime) {
        return this.toDateTime(ISODateTimeFormat.dateTimeParser().withOffsetParsed().parseDateTime(dateTime));
    }

    public String dateToString(D date) {
        try {
            return String.format(DATE_PATTERN, (Integer)PropertyUtils.getProperty(date, (String)"year"), (Integer)PropertyUtils.getProperty(date, (String)"month"), (Integer)PropertyUtils.getProperty(date, (String)"day"));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access class.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Could not get field.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not get field.", e);
        }
    }

    public DateTime toDateTime(T dateTime) {
        try {
            Object dateObj = PropertyUtils.getProperty(dateTime, (String)"date");
            return new DateTime(((Integer)PropertyUtils.getProperty((Object)dateObj, (String)"year")).intValue(), ((Integer)PropertyUtils.getProperty((Object)dateObj, (String)"month")).intValue(), ((Integer)PropertyUtils.getProperty((Object)dateObj, (String)"day")).intValue(), ((Integer)PropertyUtils.getProperty(dateTime, (String)"hour")).intValue(), ((Integer)PropertyUtils.getProperty(dateTime, (String)"minute")).intValue(), ((Integer)PropertyUtils.getProperty(dateTime, (String)"second")).intValue(), 0, DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone((String)PropertyUtils.getProperty(dateTime, (String)"timeZoneID"))));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access class.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Could not get field.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not get field.", e);
        }
    }

    public Calendar toCalendar(T dateTime) {
        return this.toDateTime(dateTime).toCalendar(Locale.getDefault());
    }

    public Calendar toCalendar(T dateTime, Locale locale) {
        return this.toDateTime(dateTime).toCalendar(locale);
    }

    public String toString(T dateTime) {
        return this.toDateTime(dateTime).toString(ISODateTimeFormat.dateHourMinuteSecond());
    }

    public String toStringWithTimeZone(T dateTime) {
        return this.toDateTime(dateTime).toString(ISODateTimeFormat.dateTimeNoMillis());
    }

    public String toStringForTimeZone(T dateTime, String newZoneID) {
        return this.toDateTime(dateTime).withZone(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(newZoneID))).toString(ISODateTimeFormat.dateHourMinuteSecond());
    }
}

