/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.v201609;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.jaxb.v201609.DownloadFormat;
import com.google.api.ads.adwords.lib.jaxb.v201609.ReportDefinition;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponseException;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.v201609.AwqlReportRequest;
import com.google.api.ads.adwords.lib.utils.v201609.DetailedReportDownloadResponseException;
import com.google.api.ads.adwords.lib.utils.v201609.ReportDownloaderInterface;
import com.google.api.ads.adwords.lib.utils.v201609.XmlReportDefinitionRequest;
import com.google.inject.Inject;

public class ReportDownloader
implements ReportDownloaderInterface {
    private final AdHocReportDownloadHelper adHocReportDownloadHelper;

    public ReportDownloader(AdWordsSession session) {
        this(AdWordsInternals.getBootstrapper().getInstanceOf(session, AdHocReportDownloadHelper.class));
    }

    @Inject
    ReportDownloader(AdHocReportDownloadHelper adHocReportDownloadHelper) {
        this.adHocReportDownloadHelper = adHocReportDownloadHelper;
    }

    @Override
    public ReportDownloadResponse downloadReport(ReportDefinition reportDefinition) throws ReportException, ReportDownloadResponseException {
        return this.adHocReportDownloadHelper.downloadReport(new XmlReportDefinitionRequest(reportDefinition), new DetailedReportDownloadResponseException.Builder());
    }

    @Override
    public ReportDownloadResponse downloadReport(String reportQuery, DownloadFormat format) throws ReportException, ReportDownloadResponseException {
        return this.adHocReportDownloadHelper.downloadReport(new AwqlReportRequest(reportQuery, format), new DetailedReportDownloadResponseException.Builder());
    }

    @Override
    public int getReportDownloadTimeout() {
        return this.adHocReportDownloadHelper.getReportDownloadTimeout();
    }

    @Override
    public void setReportDownloadTimeout(int reportDownloadTimeout) {
        this.adHocReportDownloadHelper.setReportDownloadTimeout(reportDownloadTimeout);
    }
}

