/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.factory;

import com.google.api.ads.adwords.lib.client.AdWordsServiceClient;
import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.factory.AdWordsServiceClientFactory;
import com.google.api.ads.adwords.lib.factory.AdWordsServicesInterface;
import com.google.api.ads.adwords.lib.factory.AdWordsSessionModule;
import com.google.api.ads.adwords.lib.factory.DependencyBootstrapper;
import com.google.api.ads.adwords.lib.utils.SessionUtility;
import com.google.api.ads.common.lib.factory.BaseServices;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Module;

public abstract class BaseAdWordsServices
extends BaseServices<AdWordsServiceClient, AdWordsSession, AdWordsServiceDescriptor>
implements AdWordsServicesInterface {
    final Injector injector;

    protected BaseAdWordsServices(Injector injector) {
        super(new AdWordsServiceClientFactory(injector));
        this.injector = injector;
    }

    public <UtilityT> UtilityT getUtility(AdWordsSession session, Class<UtilityT> utilityClass) {
        Preconditions.checkNotNull((Object)session, (Object)"Null session");
        Preconditions.checkNotNull(utilityClass, (Object)"Null utility class");
        if (utilityClass.getAnnotation(SessionUtility.class) == null) {
            throw new IllegalArgumentException(utilityClass + " is not annotated with " + SessionUtility.class);
        }
        Injector childInjector = this.injector.createChildInjector(new Module[]{new AdWordsSessionModule(session)});
        return (UtilityT)childInjector.getInstance(utilityClass);
    }

    protected DependencyBootstrapper createBootstrapper() {
        return (DependencyBootstrapper)this.injector.getInstance(DependencyBootstrapper.class);
    }
}

