/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.lib.client;

import com.google.api.ads.common.lib.auth.OAuth2Compatible;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.Endpoint;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Strings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

public class DfaSession
implements AdsSession,
OAuth2Compatible {
    private String authenticationToken;
    private final String username;
    private final String password;
    private final String applicationName;
    private final String endpoint;
    private final Credential oAuth2Credential;
    private static final String DEFAULT_APPLICATION_NAME = "INSERT_APPLICATION_NAME_HERE";

    private DfaSession(Builder builder) {
        this.applicationName = builder.applicationName;
        this.authenticationToken = builder.authenticationToken;
        this.endpoint = builder.endpoint;
        this.password = builder.password;
        this.username = builder.username;
        this.oAuth2Credential = builder.oAuth2Credential;
    }

    public void setToken(String token) {
        this.authenticationToken = token;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.authenticationToken;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean isEnvironment(Endpoint environment) {
        return environment.getEndpoint().equals(this.endpoint);
    }

    @Override
    public Credential getOAuth2Credential() {
        return this.oAuth2Credential;
    }

    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<DfaSession> {
        private String environmentString;
        private String username;
        private String password;
        private String authenticationToken;
        private String applicationName;
        private String endpoint;
        private Credential oAuth2Credential;
        private final ConfigurationHelper configHelper = new ConfigurationHelper();

        public Builder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            this.username = config.getString("api.dfa.username", null);
            this.password = config.getString("api.dfa.password", null);
            this.applicationName = config.getString("api.dfa.applicationName", null);
            this.authenticationToken = config.getString("api.dfa.token", null);
            this.endpoint = config.getString("api.dfa.endpoint", null);
            this.environmentString = config.getString("api.dfa.environment", null);
            return this;
        }

        public Builder withEnvironment(Environment environment) {
            this.endpoint = environment.getEndpoint();
            this.environmentString = null;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            this.environmentString = null;
            return this;
        }

        @Deprecated
        public Builder withUsernameAndPassword(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public Builder withUsernameAndToken(String username, String token) {
            this.username = username;
            this.authenticationToken = token;
            return this;
        }

        public Builder withUsernameAndOAuth2Credential(String username, Credential credential) {
            this.username = username;
            this.oAuth2Credential = credential;
            return this;
        }

        public Builder withOAuth2Credential(Credential credential) {
            this.oAuth2Credential = credential;
            return this;
        }

        public Builder withApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        @Override
        public DfaSession build() throws ValidationException {
            this.validate();
            return new DfaSession(this);
        }

        private void validate() throws ValidationException {
            boolean usingOAuth2;
            if (this.environmentString != null) {
                try {
                    this.withEnvironment(Environment.valueOf(this.environmentString.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException(String.format("Environment [%s] not recognized.", this.environmentString), "api.dfa.environment", e);
                }
            }
            if (this.username == null) {
                throw new ValidationException("Username is required.", "username");
            }
            boolean usingPassword = this.password != null;
            boolean usingToken = this.authenticationToken != null;
            boolean bl = usingOAuth2 = this.oAuth2Credential != null;
            if (!(usingPassword || usingToken || usingOAuth2)) {
                throw new ValidationException("One of username/password, username/token or username/OAuth2 must be used.", "");
            }
            if (usingPassword && usingToken || usingPassword && usingOAuth2 || usingToken && usingOAuth2) {
                throw new ValidationException("You may only use one of username/password, username/token, and username/OAuth2 at the same time.", "");
            }
            if (Strings.isNullOrEmpty((String)this.applicationName) || this.applicationName.contains(DfaSession.DEFAULT_APPLICATION_NAME)) {
                throw new ValidationException(String.format("Application name must be set and not be the default [%s]", DfaSession.DEFAULT_APPLICATION_NAME), "applicationName");
            }
            try {
                new URL(this.endpoint);
            }
            catch (MalformedURLException e) {
                throw new ValidationException("Endpoint is required and must be a valid URL.", "endpoint", e);
            }
        }
    }

    public static enum Environment implements Endpoint
    {
        PRODUCTION("https://advertisersapi.doubleclick.net"),
        TEST("https://advertisersapitest.doubleclick.net");

        private final String endpoint;

        private Environment(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

