/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.conf;

import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.api.ads.common.lib.conf.AdsBuildConfiguration;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationModule
extends AbstractModule {
    private final String BUILD_PROPERTIES = "props/google-ads-api-java-build.properties";
    private final ConfigurationHelper configurationHelper;

    public ConfigurationModule() {
        this.configurationHelper = new ConfigurationHelper();
    }

    @VisibleForTesting
    ConfigurationModule(ConfigurationHelper configurationHelper) {
        this.configurationHelper = configurationHelper;
    }

    protected void configure() {
    }

    protected void configureConfigurations(Class<? extends AdsApiConfiguration> apiConfigurationClass, List<URL> apiProperties, Class<? extends AdsLibConfiguration> adsLibConfigurationClass, List<URL> libProperties, Class<? extends AdsBuildConfiguration> adsBuildConfigurationClass, List<URL> buildProperties) {
        this.bind(AdsApiConfiguration.class).to(apiConfigurationClass).asEagerSingleton();
        this.bind(AdsLibConfiguration.class).to(adsLibConfigurationClass).asEagerSingleton();
        this.bind(AdsBuildConfiguration.class).to(adsBuildConfigurationClass).asEagerSingleton();
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"api")).toProvider((Provider)new ConfigurationProvider(apiProperties));
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"lib")).toProvider((Provider)new ConfigurationProvider(libProperties));
        buildProperties.add(ConfigurationModule.class.getResource("props/google-ads-api-java-build.properties"));
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"build")).toProvider((Provider)new ConfigurationProvider(buildProperties));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigurationProvider
    implements Provider<Configuration> {
        private final List<URL> propertyUrls;

        public ConfigurationProvider(List<URL> propertyUrls) {
            this.propertyUrls = propertyUrls;
        }

        public Configuration get() {
            CombinedConfiguration combinedConfiguration = new CombinedConfiguration();
            for (URL propertyUrl : this.propertyUrls) {
                if (propertyUrl == null) continue;
                final Configuration configuration = ConfigurationModule.this.configurationHelper.fromFile(propertyUrl);
                if (configuration instanceof AbstractConfiguration) {
                    combinedConfiguration.addConfiguration((AbstractConfiguration)configuration);
                    continue;
                }
                combinedConfiguration.addConfiguration(new AbstractConfiguration(){

                    public boolean isEmpty() {
                        return configuration.isEmpty();
                    }

                    public Object getProperty(String key) {
                        return configuration.getProperty(key);
                    }

                    public Iterator getKeys() {
                        return configuration.getKeys();
                    }

                    public boolean containsKey(String key) {
                        return configuration.containsKey(key);
                    }

                    protected void addPropertyDirect(String key, Object value) {
                        configuration.addProperty(key, value);
                    }
                });
            }
            return combinedConfiguration;
        }
    }
}

