/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.common.lib.auth.OAuth2AuthorizationHeaderProvider;
import com.google.api.ads.common.lib.auth.OAuthAuthorizationHeaderProvider;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.client.http.GenericUrl;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUrlConnectionHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(AdHocReportDownloadHelper.class.getPackage().getName()) + ".report_download"));
    public static final String DOWNLOAD_SERVER_URI = "/api/adwords/reportdownload";
    private static final String REQUEST_METHOD = "POST";
    private final OAuthAuthorizationHeaderProvider oAuthAuthorizationHeaderProvider;
    private final OAuth2AuthorizationHeaderProvider oAuth2AuthorizationHeaderProvider;
    private final AdWordsSession session;

    ReportUrlConnectionHelper(AdWordsSession session) {
        this.session = session;
        this.oAuthAuthorizationHeaderProvider = new OAuthAuthorizationHeaderProvider(REQUEST_METHOD);
        this.oAuth2AuthorizationHeaderProvider = new OAuth2AuthorizationHeaderProvider();
    }

    @VisibleForTesting
    HttpURLConnection getReportHttpUrlConnection(String reportUrl) throws MalformedURLException, IOException, ReportException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)new URL(reportUrl).openConnection();
        httpUrlConnection.setRequestMethod(REQUEST_METHOD);
        logger.info("{} {}", (Object)REQUEST_METHOD, (Object)reportUrl);
        if (this.session.getClientLoginToken() != null) {
            httpUrlConnection.setRequestProperty("Authorization", "GoogleLogin auth=" + this.session.getClientLoginToken());
        } else if (this.session.getOAuthParameters() != null) {
            try {
                String authorizationHeader = this.oAuthAuthorizationHeaderProvider.getOAuthAuthorizationHeader(this.session, new GenericUrl(reportUrl));
                httpUrlConnection.setRequestProperty("Authorization", authorizationHeader);
            }
            catch (OAuthException e) {
                throw new ReportException("Could not set OAuth header", e);
            }
        } else if (this.session.getOAuth2Credential() != null) {
            String authorizationHeader = this.oAuth2AuthorizationHeaderProvider.getOAuth2AuthorizationHeader(this.session);
            httpUrlConnection.setRequestProperty("Authorization", authorizationHeader);
        } else {
            throw new IllegalArgumentException("Either ClientLoginToken or OAuth header must be provided.");
        }
        httpUrlConnection.setRequestProperty("developerToken", this.session.getDeveloperToken());
        logger.info("developerToken: {}", (Object)this.session.getDeveloperToken());
        httpUrlConnection.setRequestProperty("clientCustomerId", this.session.getClientCustomerId());
        logger.info("clientCustomerId: {}", (Object)this.session.getClientCustomerId());
        httpUrlConnection.setRequestProperty("returnMoneyInMicros", Boolean.toString(this.session.isReportMoneyInMicros()));
        logger.info("returnMoneyInMicros: {}", (Object)this.session.isReportMoneyInMicros());
        return httpUrlConnection;
    }
}

