/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.conf;

import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.OverrideCombiner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelper {
    public Configuration fromFile(String path) throws ConfigurationLoadException {
        PropertiesConfiguration propertiesConfiguration = this.setupConfiguration(new PropertiesConfiguration());
        propertiesConfiguration.setFileName(path);
        try {
            propertiesConfiguration.load();
        }
        catch (ConfigurationException e) {
            if (Throwables.getRootCause((Throwable)e) instanceof AccessControlException) {
                AdsServiceLoggers.ADS_API_LIB_LOG.debug("Properties could not be loaded.", (Throwable)e);
            }
            throw new ConfigurationLoadException("Encountered a problem reading the provided configuration file \"" + path + "\"!", e);
        }
        return propertiesConfiguration;
    }

    public Configuration fromFile(File path) throws ConfigurationLoadException {
        PropertiesConfiguration configuration = this.setupConfiguration(new PropertiesConfiguration());
        configuration.setFile(path);
        try {
            configuration.load();
            return configuration;
        }
        catch (ConfigurationException e) {
            throw new ConfigurationLoadException("Encountered a problem reading the provided configuration file \"" + path + "\"!", e);
        }
    }

    public Configuration fromFile(URL path) throws ConfigurationLoadException {
        PropertiesConfiguration configuration = this.setupConfiguration(new PropertiesConfiguration());
        configuration.setURL(path);
        try {
            configuration.load();
            return configuration;
        }
        catch (ConfigurationException e) {
            throw new ConfigurationLoadException("Encountered a problem reading the provided configuration file \"" + path + "\"!", e);
        }
    }

    public Configuration fromSystem() {
        MapConfiguration mapConfig = this.setupConfiguration(new MapConfiguration((Map)((Properties)System.getProperties().clone())));
        mapConfig.setTrimmingDisabled(true);
        return mapConfig;
    }

    public CombinedConfiguration createCombinedConfiguration(@Nullable List<ConfigurationInfo<String>> paths, @Nullable List<ConfigurationInfo<URL>> urls) throws ConfigurationLoadException {
        CombinedConfiguration combinedConfiguration = this.setupConfiguration(new CombinedConfiguration((NodeCombiner)new OverrideCombiner()));
        this.addConfiguration(combinedConfiguration, this.fromSystem());
        if (paths != null) {
            for (ConfigurationInfo<Object> configurationInfo : paths) {
                if (configurationInfo == null || configurationInfo.getLocation() == null) continue;
                try {
                    this.addConfiguration(combinedConfiguration, this.fromFile((String)configurationInfo.getLocation()));
                }
                catch (ConfigurationLoadException e) {
                    if (!((ConfigurationInfo)configurationInfo).isOptional) {
                        throw e;
                    }
                    AdsServiceLoggers.ADS_API_LIB_LOG.debug("Did not load optional configuration " + (String)configurationInfo.getLocation() + ":", (Throwable)e);
                }
            }
        }
        if (urls != null) {
            for (ConfigurationInfo<Object> configurationInfo : urls) {
                if (configurationInfo == null || configurationInfo.getLocation() == null) continue;
                try {
                    this.addConfiguration(combinedConfiguration, this.fromFile((URL)configurationInfo.getLocation()));
                }
                catch (ConfigurationLoadException e) {
                    if (!((ConfigurationInfo)configurationInfo).isOptional) {
                        throw e;
                    }
                    AdsServiceLoggers.ADS_API_LIB_LOG.debug("Did not load optional configuration" + configurationInfo.getLocation() + ":", (Throwable)e);
                }
            }
        }
        return combinedConfiguration;
    }

    @VisibleForTesting
    void addConfiguration(CombinedConfiguration combinedConfiguration, final Configuration configuration) {
        if (configuration instanceof AbstractConfiguration) {
            combinedConfiguration.addConfiguration((AbstractConfiguration)configuration);
        } else {
            combinedConfiguration.addConfiguration((AbstractConfiguration)this.setupConfiguration(new AbstractConfiguration(){

                public boolean isEmpty() {
                    return configuration.isEmpty();
                }

                public Object getProperty(String key) {
                    return configuration.getProperty(key);
                }

                public Iterator getKeys() {
                    return configuration.getKeys();
                }

                public boolean containsKey(String key) {
                    return configuration.containsKey(key);
                }

                protected void addPropertyDirect(String key, Object value) {
                    configuration.addProperty(key, value);
                }
            }));
        }
    }

    public static <T> List<ConfigurationInfo<T>> newList(@Nullable List<T> locations, final boolean isOptional) {
        if (locations == null) {
            return null;
        }
        return Lists.transform(locations, (Function)new Function<T, ConfigurationInfo<T>>(){

            public ConfigurationInfo<T> apply(T input) {
                return new ConfigurationInfo(input, isOptional);
            }
        });
    }

    public static <T> List<ConfigurationInfo<T>> newList(boolean isOptional, T ... locations) {
        if (locations == null) {
            throw new IllegalArgumentException("locations cannot be null");
        }
        return ConfigurationHelper.newList(Lists.newArrayList((Object[])locations), isOptional);
    }

    private <C extends AbstractConfiguration> C setupConfiguration(C configuration) {
        configuration.setListDelimiter(',');
        configuration.setDelimiterParsingDisabled(false);
        return configuration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationInfo<T> {
        private final T location;
        private final boolean isOptional;

        public ConfigurationInfo(T location, boolean isOptional) {
            if (!(location instanceof String) && !(location instanceof URL)) {
                throw new IllegalArgumentException("Type " + location.getClass() + " not supported as a configuration location.");
            }
            this.location = location;
            this.isOptional = isOptional;
        }

        public T getLocation() {
            return this.location;
        }

        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

