/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.common.lib.auth.OAuth2Helper;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.common.lib.utils.Internals;
import com.google.api.ads.dfa.lib.utils.DfaInternals;
import com.google.api.ads.dfp.lib.utils.DfpInternals;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;

public class OfflineCredentials {
    private final HttpTransport httpTransport;
    private final String refreshToken;
    private final String clientId;
    private final String clientSecret;
    private final OAuth2Helper oAuth2Helper;
    private final String tokenServerUrl;

    private OfflineCredentials(ForApiBuilder builder) {
        this.httpTransport = builder.httpTransport;
        this.refreshToken = builder.refreshToken;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.oAuth2Helper = builder.oAuth2Helper;
        this.tokenServerUrl = builder.tokenServerUrl;
    }

    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Credential generateCredential() throws OAuthException {
        GoogleCredential credential = new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory((JsonFactory)new JacksonFactory()).setClientSecrets(this.clientId, this.clientSecret).setTokenServerEncodedUrl(this.tokenServerUrl).build();
        credential.setRefreshToken(this.refreshToken);
        try {
            if (!this.oAuth2Helper.callRefreshToken((Credential)credential)) {
                throw new OAuthException("Credential could not be refreshed. A newly generated refresh token may be required.");
            }
        }
        catch (IOException e) {
            throw new OAuthException("Credential could not be refreshed.", e);
        }
        return credential;
    }

    /* synthetic */ OfflineCredentials(ForApiBuilder forApiBuilder, OfflineCredentials offlineCredentials) {
        this(forApiBuilder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Api {
        ADWORDS("api.adwords.", AdWordsInternals.getInstance()),
        DFA("api.dfa.", DfaInternals.getInstance()),
        DFP("api.dfp.", DfpInternals.getInstance());

        private final String propKeyPrefix;
        private final Internals internals;

        private Api(String propKeyPrefix, Internals internals) {
            this.propKeyPrefix = propKeyPrefix;
            this.internals = internals;
        }

        public String getPropKeyPrefix() {
            return this.propKeyPrefix;
        }

        Internals getInternals() {
            return this.internals;
        }
    }

    public static class Builder {
        @Nullable
        private OAuth2Helper oAuth2Helper;

        public Builder() {
            this(null);
        }

        @VisibleForTesting
        Builder(@Nullable OAuth2Helper oAuth2Helper) {
            this.oAuth2Helper = oAuth2Helper;
        }

        public ForApiBuilder forApi(Api api) {
            this.defaultOptionals(api);
            return new ForApiBuilder(api, this.oAuth2Helper);
        }

        private void defaultOptionals(Api api) {
            if (this.oAuth2Helper == null) {
                this.oAuth2Helper = api.getInternals().getOAuth2Helper();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForApiBuilder
    implements com.google.api.ads.common.lib.utils.Builder<OfflineCredentials> {
        @VisibleForTesting
        static final HttpTransport DEFAULT_HTTP_TRANSPORT = new NetHttpTransport();
        private HttpTransport httpTransport;
        private String refreshToken;
        private String clientId;
        private String clientSecret;
        private String filePath;
        private String tokenServerUrl;
        private final ConfigurationHelper configHelper;
        private final Api api;
        private final OAuth2Helper oAuth2Helper;

        private ForApiBuilder(Api api, OAuth2Helper oAuth2Helper) {
            this(new ConfigurationHelper(), api, oAuth2Helper);
        }

        @VisibleForTesting
        ForApiBuilder(ConfigurationHelper configHelper, Api api, OAuth2Helper oAuth2Helper) {
            this.configHelper = configHelper;
            this.api = api;
            this.oAuth2Helper = oAuth2Helper;
        }

        public ForApiBuilder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path), path.toString());
        }

        public ForApiBuilder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path), path.getAbsolutePath());
        }

        public ForApiBuilder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path), path.toString());
        }

        public ForApiBuilder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public ForApiBuilder from(Configuration config) {
            this.refreshToken = config.getString(this.getPropertyKey("refreshToken"), null);
            this.clientId = config.getString(this.getPropertyKey("clientId"), null);
            this.clientSecret = config.getString(this.getPropertyKey("clientSecret"), null);
            return this;
        }

        ForApiBuilder from(Configuration config, String filePath) {
            this.from(config);
            this.filePath = filePath;
            return this;
        }

        public ForApiBuilder withClientSecrets(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            return this;
        }

        public ForApiBuilder withRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public ForApiBuilder withHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public ForApiBuilder withTokenUrlServer(String tokenServerUrl) {
            this.tokenServerUrl = tokenServerUrl;
            return this;
        }

        private void validate() throws ValidationException {
            if (Strings.isNullOrEmpty((String)this.clientId)) {
                throw new ValidationException(String.format("Client ID must be set%s\nIf you do not have a client ID or secret, please create one in the API console: https://code.google.com/apis/console#access", this.filePath != null ? this.generateFilePathWarning("clientId") : "."), "clientId");
            }
            if (Strings.isNullOrEmpty((String)this.clientSecret)) {
                throw new ValidationException(String.format("Client secret must be set%s\nIf you do not have a client ID or secret, please create one in the API console: https://code.google.com/apis/console#access", this.filePath != null ? this.generateFilePathWarning("clientSecret") : "."), "clientSecret");
            }
            if (Strings.isNullOrEmpty((String)this.refreshToken)) {
                throw new ValidationException(String.format("A refresh token must be set%s\nIt is required for offline credentials. If you need to create one, see the GetRefreshToken example.", this.filePath != null ? this.generateFilePathWarning("refreshToken") : "."), "refreshToken");
            }
        }

        private String generateFilePathWarning(String key) {
            return String.format(" as %s in %s.", this.getPropertyKey(key), this.filePath);
        }

        private void defaultOptionals() {
            if (this.httpTransport == null) {
                this.httpTransport = DEFAULT_HTTP_TRANSPORT;
            }
            if (this.tokenServerUrl == null) {
                this.tokenServerUrl = "https://accounts.google.com/o/oauth2/token";
            }
        }

        @Override
        public OfflineCredentials build() throws ValidationException {
            this.defaultOptionals();
            this.validate();
            return new OfflineCredentials(this, null);
        }

        private String getPropertyKey(String suffix) {
            return String.valueOf(this.api.getPropKeyPrefix()) + suffix;
        }
    }
}

