/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.lib.client;

import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.soap.compatability.AxisCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfaServiceDescriptor
implements AdsServiceDescriptor,
AxisCompatible {
    private final Class<?> interfaceClass;
    private final String version;

    @Inject
    public DfaServiceDescriptor(@Assisted(value="interfaceClass") Class<?> interfaceClass, @Assisted(value="version") String version) {
        this.interfaceClass = interfaceClass;
        this.version = version;
    }

    @Override
    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    @Override
    public Class<?> getLocatorClass() throws ClassNotFoundException {
        return Class.forName(String.valueOf(this.interfaceClass.getCanonicalName()) + "ServiceLocator");
    }

    @VisibleForTesting
    protected String getServiceName() {
        String simpleName = this.interfaceClass.getSimpleName();
        String serviceName = simpleName.substring(0, simpleName.indexOf("Remote")).toLowerCase();
        if ("placementstrategy".equalsIgnoreCase(serviceName)) {
            return "strategy";
        }
        return serviceName;
    }

    @Override
    public String getEndpointAddress(String endpointServer) {
        return String.valueOf(endpointServer) + "/" + this.version + "/api/dfa-api/" + this.getServiceName();
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

