/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.conf;

import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.commons.configuration.Configuration;

public class AdWordsApiConfiguration
extends AdsApiConfiguration {
    public static final String NAMESPACE_PREFIX_KEY = "api.adwords.namespace.prefix";

    @Inject
    public AdWordsApiConfiguration(@Named(value="api") Configuration config) {
        super(config);
    }

    public String getNamespacePrefix() {
        return this.getString(NAMESPACE_PREFIX_KEY);
    }

    public String getServiceUrlGroup(String version, String service) {
        String[] groups;
        String[] stringArray = groups = this.config.getStringArray("api.adwords.version." + version + ".groups");
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            Object[] services = this.config.getStringArray("api.adwords.version." + version + "." + group + ".services");
            if (Lists.newArrayList((Object[])services).contains(service)) {
                return group;
            }
            ++n2;
        }
        throw new NullPointerException("No group found for service: " + version + "." + service);
    }
}

