/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.lib.factory.helper;

import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.factory.FactoryModule;
import com.google.api.ads.common.lib.factory.helper.BaseAdsServiceClientFactoryHelper;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.dfp.lib.client.DfpServiceClient;
import com.google.api.ads.dfp.lib.client.DfpServiceDescriptor;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfpServiceClientFactoryHelper
extends BaseAdsServiceClientFactoryHelper<DfpServiceClient, DfpSession, DfpServiceDescriptor> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^.*(v[0-9][^\\.]*).*$");
    private final AdsLibConfiguration adsLibConfiguration;

    @Inject
    public DfpServiceClientFactoryHelper(FactoryModule.AdsServiceClientFactoryInterface<DfpServiceClient, DfpSession, DfpServiceDescriptor> adsServiceClientFactory, FactoryModule.AdsServiceDescriptorFactoryInterface<DfpServiceDescriptor> adsServiceDescriptorFactory, SoapClientHandlerInterface soapClientHandler, AdsLibConfiguration adsLibConfiguration) {
        super(adsServiceClientFactory, adsServiceDescriptorFactory, soapClientHandler);
        this.adsLibConfiguration = adsLibConfiguration;
    }

    @Override
    public String determineVersion(Class<?> interfaceClass) {
        Matcher m = VERSION_PATTERN.matcher(interfaceClass.getPackage().getName());
        if (m.matches()) {
            String version = m.group(1);
            return version.replace('_', '.');
        }
        return this.adsLibConfiguration.getDuckTypedVersion();
    }
}

