/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.client;

import com.google.api.ads.common.lib.auth.ClientLoginCompatible;
import com.google.api.ads.common.lib.auth.OAuth2Compatible;
import com.google.api.ads.common.lib.auth.OAuthCompatible;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.Endpoint;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

public class AdWordsSession
implements AdsSession,
OAuthCompatible,
OAuth2Compatible,
ClientLoginCompatible {
    private String endpoint;
    private String clientLoginToken;
    private String userAgent;
    private String developerToken;
    private String clientCustomerId;
    private OAuthParameters oAuthParameters;
    private Boolean isPartialFailure;
    private Boolean isValidateOnly;
    private Boolean isReportMoneyInMicros = Boolean.FALSE;
    private Credential oAuth2Credential;
    public static final String DEFAULT_ENDPOINT = "https://adwords.google.com/";

    private AdWordsSession() {
    }

    private AdWordsSession(AdWordsSession copy) {
        this.clientCustomerId = copy.clientCustomerId;
        this.clientLoginToken = copy.clientLoginToken;
        this.developerToken = copy.developerToken;
        this.endpoint = copy.endpoint;
        this.isPartialFailure = copy.isPartialFailure;
        this.isReportMoneyInMicros = copy.isReportMoneyInMicros;
        this.isValidateOnly = copy.isValidateOnly;
        this.oAuth2Credential = copy.oAuth2Credential;
        this.oAuthParameters = copy.oAuthParameters;
        this.userAgent = copy.userAgent;
    }

    public String getClientCustomerId() {
        return this.clientCustomerId;
    }

    public void setClientCustomerId(String clientCustomerId) {
        this.clientCustomerId = clientCustomerId;
    }

    public Boolean isValidateOnly() {
        return this.isValidateOnly;
    }

    public void setValidateOnly(Boolean isValidateOnly) {
        this.isValidateOnly = isValidateOnly;
    }

    public void setPartialFailure(Boolean isPartialFailure) {
        this.isPartialFailure = isPartialFailure;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getDeveloperToken() {
        return this.developerToken;
    }

    public Boolean isPartialFailure() {
        return this.isPartialFailure;
    }

    @Deprecated
    public OAuthParameters getOAuthParameters() {
        return this.oAuthParameters;
    }

    @Deprecated
    public void setOAuthParameters(OAuthParameters oAuthParameters) {
        Preconditions.checkNotNull((Object)oAuthParameters, (Object)"oAuthParameters cannot be null.");
        this.clearAuthentication();
        this.oAuthParameters = oAuthParameters;
    }

    public Credential getOAuth2Credential() {
        return this.oAuth2Credential;
    }

    public void setOAuth2Credential(Credential oAuth2Credential) {
        Preconditions.checkNotNull((Object)oAuth2Credential, (Object)"oAuth2Credential cannot be null.");
        this.clearAuthentication();
        this.oAuth2Credential = oAuth2Credential;
    }

    public String getClientLoginToken() {
        return this.clientLoginToken;
    }

    public void setClientLoginToken(String clientLoginToken) {
        Preconditions.checkNotNull((Object)clientLoginToken, (Object)"clientLoginToken cannot be null.");
        this.clearAuthentication();
        this.clientLoginToken = clientLoginToken;
    }

    private void clearAuthentication() {
        this.oAuth2Credential = null;
        this.oAuthParameters = null;
        this.clientLoginToken = null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setReportMoneyInMicros(Boolean reportMoneyInMicros) {
        this.isReportMoneyInMicros = reportMoneyInMicros;
    }

    public Boolean isReportMoneyInMicros() {
        return this.isReportMoneyInMicros;
    }

    @Deprecated
    public boolean isEnvironment(Endpoint environment) {
        return environment.getEndpoint().equals(this.endpoint);
    }

    /* synthetic */ AdWordsSession(AdWordsSession adWordsSession, AdWordsSession adWordsSession2) {
        this();
    }

    /* synthetic */ AdWordsSession(AdWordsSession adWordsSession, AdWordsSession adWordsSession2, AdWordsSession adWordsSession3) {
        this(adWordsSession);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<AdWordsSession> {
        private AdWordsSession adWordsSession = new AdWordsSession(null, null);
        private String environmentString;
        @VisibleForTesting
        ConfigurationHelper configHelper;

        public Builder() {
            this.configHelper = new ConfigurationHelper();
        }

        @VisibleForTesting
        Builder(ConfigurationHelper configHelper) {
            this.configHelper = configHelper;
        }

        public Builder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            this.adWordsSession.clientLoginToken = config.getString("api.adwords.clientLoginToken", null);
            this.adWordsSession.clientCustomerId = config.getString("api.adwords.clientCustomerId", null);
            this.adWordsSession.userAgent = config.getString("api.adwords.userAgent", null);
            this.adWordsSession.developerToken = config.getString("api.adwords.developerToken", null);
            this.adWordsSession.isPartialFailure = config.getBoolean("api.adwords.isPartialFailure", null);
            this.adWordsSession.endpoint = config.getString("api.adwords.endpoint", null);
            this.adWordsSession.isReportMoneyInMicros = config.getBoolean("api.adwords.reportMoneyInMicros", Boolean.FALSE);
            this.environmentString = config.getString("api.adwords.environment", null);
            return this;
        }

        public Builder withClientLoginToken(String clientLoginToken) {
            this.adWordsSession.setClientLoginToken(clientLoginToken);
            return this;
        }

        public Builder withDeveloperToken(String developerToken) {
            this.adWordsSession.developerToken = developerToken;
            return this;
        }

        @Deprecated
        public Builder withOAuthParameters(OAuthParameters oAuthParameters) {
            this.adWordsSession.setOAuthParameters(oAuthParameters);
            return this;
        }

        public Builder withOAuth2Credential(Credential oAuth2Credential) {
            this.adWordsSession.setOAuth2Credential(oAuth2Credential);
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.adWordsSession.userAgent = userAgent;
            return this;
        }

        @Deprecated
        public Builder withEnvironment(Environment environment) {
            this.adWordsSession.endpoint = environment.getEndpoint();
            this.environmentString = null;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.adWordsSession.endpoint = endpoint;
            this.environmentString = null;
            return this;
        }

        public Builder withClientCustomerId(String clientCustomerId) {
            this.adWordsSession.clientCustomerId = clientCustomerId;
            return this;
        }

        public Builder enablePartialFailure() {
            this.adWordsSession.isPartialFailure = true;
            return this;
        }

        public Builder enableReportMoneyInMicros() {
            this.adWordsSession.isReportMoneyInMicros = true;
            return this;
        }

        @Override
        public AdWordsSession build() throws ValidationException {
            this.defaultOptionals();
            this.validate(this.adWordsSession);
            return new AdWordsSession(this.adWordsSession, null, null);
        }

        private void defaultOptionals() {
            if (this.adWordsSession.endpoint == null) {
                this.adWordsSession.endpoint = AdWordsSession.DEFAULT_ENDPOINT;
            }
        }

        private void validate(AdWordsSession adWordsSession) throws ValidationException {
            if (this.environmentString != null) {
                try {
                    this.withEnvironment(Environment.valueOf(this.environmentString.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException(String.format("Environment [%s] not recognized.", this.environmentString), "api.adwords.environment", e);
                }
            }
            if (adWordsSession.getClientLoginToken() != null && (adWordsSession.getOAuthParameters() != null || adWordsSession.getOAuth2Credential() != null)) {
                throw new ValidationException("Only one of ClientLogin authentication (clientLoginToken),  OAuth or OAuth2 authentication cannot be used at the same time.", "");
            }
            if (adWordsSession.getClientLoginToken() == null && adWordsSession.getOAuthParameters() != null && adWordsSession.getOAuth2Credential() != null) {
                throw new ValidationException("Both OAuth and OAuth2 cannot be used at the same time.", "");
            }
            if (adWordsSession.getClientLoginToken() == null && adWordsSession.getOAuthParameters() == null && adWordsSession.getOAuth2Credential() == null) {
                throw new ValidationException("One of ClientLogin authentication, OAuth, or OAuth2 authentication must be used.", "");
            }
            if (adWordsSession.getDeveloperToken() == null) {
                throw new ValidationException("A developer token must be set.", "developerToken");
            }
            try {
                new URL(adWordsSession.getEndpoint());
            }
            catch (MalformedURLException e) {
                throw new ValidationException(String.format("Endpoint [%s] not recognized as a valid URL.", adWordsSession.getEndpoint()), "endpoint", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum Environment implements Endpoint
    {
        PRODUCTION("https://adwords.google.com/");

        private final String endpoint;

        private Environment(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

