/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.common.lib.auth.AuthorizationHeaderProvider;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.common.lib.utils.Internals;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportRequestFactoryHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(AdHocReportDownloadHelper.class.getPackage().getName()) + ".report_download"));
    public static final String DOWNLOAD_SERVER_URI = "/api/adwords/reportdownload";
    private final AdWordsSession session;
    private final UserAgentCombiner userAgentCombiner;
    private final AuthorizationHeaderProvider authorizationHeaderProvider;
    private final HttpTransport httpTransport;

    ReportRequestFactoryHelper(AdWordsSession session) {
        this(session, AdWordsInternals.getInstance());
    }

    @VisibleForTesting
    ReportRequestFactoryHelper(AdWordsSession session, Internals internals) {
        this(session, internals.getAuthorizationHeaderProvider(), internals.getUserAgentCombiner(), internals.getHttpTransport());
    }

    @VisibleForTesting
    ReportRequestFactoryHelper(AdWordsSession session, AuthorizationHeaderProvider authorizationHeaderProvider, UserAgentCombiner userAgentCombiner, HttpTransport httpTransport) {
        this.session = session;
        this.authorizationHeaderProvider = authorizationHeaderProvider;
        this.userAgentCombiner = userAgentCombiner;
        this.httpTransport = httpTransport;
    }

    @VisibleForTesting
    HttpRequestFactory getHttpRequestFactory(String reportUrl) throws AuthenticationException {
        final HttpHeaders httpHeaders = this.createHeaders(reportUrl);
        return this.httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.setHeaders(httpHeaders);
                request.setThrowExceptionOnExecuteError(false);
                request.setLoggingEnabled(true);
            }
        });
    }

    private HttpHeaders createHeaders(String reportUrl) throws AuthenticationException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAuthorization(this.authorizationHeaderProvider.getAuthorizationHeader(this.session, reportUrl));
        httpHeaders.setUserAgent(this.userAgentCombiner.getUserAgent(this.session.getUserAgent()));
        httpHeaders.set("developerToken", (Object)this.session.getDeveloperToken());
        httpHeaders.set("clientCustomerId", (Object)this.session.getClientCustomerId());
        httpHeaders.set("returnMoneyInMicros", (Object)Boolean.toString(this.session.isReportMoneyInMicros()));
        return httpHeaders;
    }
}

