/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class Media {
    private Media() {
    }

    public static byte[] getMediaDataFromFile(String fileName) throws IOException {
        return Media.getMediaDataFromFile(new File(fileName));
    }

    public static byte[] getMediaDataFromFile(File file) throws IOException {
        return Media.getByteArrayFromStream(new FileInputStream(file));
    }

    public static byte[] getMediaDataFromUrl(String url) throws IOException {
        return Media.getMediaDataFromUrl(new URL(url));
    }

    public static byte[] getMediaDataFromUrl(URL url) throws IOException {
        return Media.getByteArrayFromStream(url.openStream());
    }

    private static byte[] getByteArrayFromStream(final InputStream inputStream) throws IOException {
        return ByteStreams.toByteArray((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() {
                return inputStream;
            }
        });
    }
}

