/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.jaxws;

import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.RequestInfo;
import com.google.api.ads.common.lib.soap.ResponseInfo;
import com.google.api.ads.common.lib.soap.SoapCall;
import com.google.api.ads.common.lib.soap.SoapCallReturn;
import com.google.api.ads.common.lib.soap.SoapClientHandler;
import com.google.api.ads.common.lib.soap.SoapServiceDescriptor;
import com.google.api.ads.common.lib.soap.compatability.JaxWsCompatible;
import com.google.api.ads.common.lib.soap.jaxws.JaxWsSoapContextHandler;
import com.google.api.ads.common.lib.soap.jaxws.JaxWsSoapContextHandlerFactory;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsHandler
extends SoapClientHandler<BindingProvider> {
    private static final int REQUEST_TIMEOUT = 600000;
    private static final String PRODUCTION_REQUEST_TIMEOUT_KEY = "com.sun.xml.ws.request.timeout";
    private static final String PRODUCTION_CONNECT_TIMEOUT_KEY = "com.sun.xml.ws.connect.timeout";
    private static final String DEVEL_REQUEST_TIMEOUT_KEY = "com.sun.xml.internal.ws.request.timeout";
    private static final String DEVEL_CONNECT_TIMEOUT_KEY = "com.sun.xml.internal.ws.connect.timeout";
    private static final String[] CARRY_OVER_HTTP_HEADERS = new String[]{"Accept-Encoding", "Content-Encoding"};
    private JaxWsSoapContextHandlerFactory contextHandlerFactory;

    @Inject
    protected JaxWsHandler(JaxWsSoapContextHandlerFactory contextHandlerFactory) {
        this.contextHandlerFactory = contextHandlerFactory;
    }

    public void setEndpointAddress(BindingProvider soapClient, String endpointAddress) {
        soapClient.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointAddress);
    }

    public Object getHeader(BindingProvider soapClient, String headerName) {
        for (SOAPElement addedHeader : this.getContextHandlerFromClient(soapClient).getAddedHeaders()) {
            if (!addedHeader.getNodeName().equals(headerName)) continue;
            return addedHeader;
        }
        return null;
    }

    public void clearHeaders(BindingProvider soapClient) {
        this.getContextHandlerFromClient(soapClient).clearHeaders();
    }

    public void setHeader(BindingProvider soapClient, String namespace, String headerName, Object headerValue) {
        if (!(headerValue instanceof SOAPElement)) {
            throw new ServiceException("Unexpected SOAP header given for JAX-WS binding. Given object of class \"" + headerValue.getClass().toString() + "\" but expecting " + "object of class \"" + SOAPElement.class.toString() + "\".", null);
        }
        this.getContextHandlerFromClient(soapClient).addHeader(namespace, headerName, (SOAPElement)headerValue);
    }

    public void setHttpHeaders(BindingProvider soapClient, Map<String, String> headersMap) {
        HashMap<String, List> jaxWsCompatibleHttpHeaders = new HashMap<String, List>();
        Map existingHttpHeaders = (Map)soapClient.getRequestContext().get("javax.xml.ws.http.request.headers");
        if (existingHttpHeaders != null) {
            String[] stringArray = CARRY_OVER_HTTP_HEADERS;
            int n = CARRY_OVER_HTTP_HEADERS.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (existingHttpHeaders.containsKey(key)) {
                    jaxWsCompatibleHttpHeaders.put(key, (List)existingHttpHeaders.get(key));
                }
                ++n2;
            }
        }
        for (String key : headersMap.keySet()) {
            LinkedList<String> headerAsList = new LinkedList<String>();
            headerAsList.add(headersMap.get(key));
            jaxWsCompatibleHttpHeaders.put(key, headerAsList);
        }
        soapClient.getRequestContext().put("javax.xml.ws.http.request.headers", jaxWsCompatibleHttpHeaders);
    }

    public void setCompression(BindingProvider soapClient, boolean compress) {
        HashMap<String, List<String>> httpHeaders = (HashMap<String, List<String>>)soapClient.getRequestContext().get("javax.xml.ws.http.request.headers");
        if (httpHeaders == null) {
            httpHeaders = new HashMap<String, List<String>>();
        }
        if (compress) {
            httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
            httpHeaders.put("Content-Encoding", Collections.singletonList("gzip"));
        } else {
            List contentEncoding;
            List acceptEncoding = (List)httpHeaders.get("Accept-Encoding");
            if (acceptEncoding != null) {
                acceptEncoding.remove("gzip");
            }
            if ((contentEncoding = (List)httpHeaders.get("Content-Encoding")) != null) {
                contentEncoding.remove("gzip");
            }
        }
        soapClient.getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
    }

    public BindingProvider createSoapClient(SoapServiceDescriptor soapServiceDescriptor) throws ServiceException {
        try {
            if (soapServiceDescriptor instanceof JaxWsCompatible) {
                JaxWsCompatible jaxWsCompatibleService = (JaxWsCompatible)soapServiceDescriptor;
                Object portLocator = jaxWsCompatibleService.getServiceClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                String interfaceClassName = soapServiceDescriptor.getInterfaceClass().getSimpleName();
                BindingProvider soapClient = (BindingProvider)portLocator.getClass().getMethod("get" + interfaceClassName + "Port", new Class[0]).invoke(portLocator, new Object[0]);
                this.setTimeOut(soapClient);
                List bindings = soapClient.getBinding().getHandlerChain();
                bindings.add(this.contextHandlerFactory.getJaxWsSoapContextHandler());
                soapClient.getBinding().setHandlerChain(bindings);
                return soapClient;
            }
            throw new ServiceException("Service [" + soapServiceDescriptor + "] is not compatible with JAX-WS", null);
        }
        catch (SecurityException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
    }

    private void setTimeOut(BindingProvider bindingProvider) {
        bindingProvider.getRequestContext().put(PRODUCTION_REQUEST_TIMEOUT_KEY, 600000);
        bindingProvider.getRequestContext().put(PRODUCTION_CONNECT_TIMEOUT_KEY, 600000);
        bindingProvider.getRequestContext().put(DEVEL_REQUEST_TIMEOUT_KEY, 600000);
        bindingProvider.getRequestContext().put(DEVEL_CONNECT_TIMEOUT_KEY, 600000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoapCallReturn invokeSoapCall(SoapCall<BindingProvider> soapCall) {
        BindingProvider webService = (BindingProvider)soapCall.getSoapClient();
        SoapCallReturn.Builder builder = new SoapCallReturn.Builder();
        BindingProvider bindingProvider = webService;
        synchronized (bindingProvider) {
            Object result;
            block10: {
                result = null;
                try {
                    result = this.invoke(soapCall);
                }
                catch (InvocationTargetException e) {
                    builder.withException(e.getTargetException());
                    JaxWsSoapContextHandler contextHandler = this.getContextHandlerFromClient(webService);
                    builder.withRequestInfo(new RequestInfo.Builder().withSoapRequestXml(contextHandler.getLastRequestXml()).withMethodName(contextHandler.getLastOperationCalled()).withServiceName(contextHandler.getLastServiceCalled()).withUrl((String)webService.getRequestContext().get("javax.xml.ws.service.endpoint.address")).build());
                    builder.withResponseInfo(new ResponseInfo.Builder().withSoapResponseXml(contextHandler.getLastResponseXml()).build());
                    break block10;
                }
                catch (Exception e) {
                    try {
                        builder.withException((Throwable)e);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        JaxWsSoapContextHandler contextHandler = this.getContextHandlerFromClient(webService);
                        builder.withRequestInfo(new RequestInfo.Builder().withSoapRequestXml(contextHandler.getLastRequestXml()).withMethodName(contextHandler.getLastOperationCalled()).withServiceName(contextHandler.getLastServiceCalled()).withUrl((String)webService.getRequestContext().get("javax.xml.ws.service.endpoint.address")).build());
                        builder.withResponseInfo(new ResponseInfo.Builder().withSoapResponseXml(contextHandler.getLastResponseXml()).build());
                    }
                }
                JaxWsSoapContextHandler contextHandler = this.getContextHandlerFromClient(webService);
                builder.withRequestInfo(new RequestInfo.Builder().withSoapRequestXml(contextHandler.getLastRequestXml()).withMethodName(contextHandler.getLastOperationCalled()).withServiceName(contextHandler.getLastServiceCalled()).withUrl((String)webService.getRequestContext().get("javax.xml.ws.service.endpoint.address")).build());
                builder.withResponseInfo(new ResponseInfo.Builder().withSoapResponseXml(contextHandler.getLastResponseXml()).build());
            }
            return builder.withReturnValue(result).build();
        }
    }

    public String getEndpointAddress(BindingProvider soapClient) {
        return (String)soapClient.getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    public SOAPHeaderElement createSoapHeaderElement(QName qName) {
        throw new UnsupportedOperationException();
    }

    private JaxWsSoapContextHandler getContextHandlerFromClient(BindingProvider soapClient) {
        List handlers = soapClient.getBinding().getHandlerChain();
        for (Handler handler : handlers) {
            if (!(handler instanceof JaxWsSoapContextHandler)) continue;
            return (JaxWsSoapContextHandler)handler;
        }
        throw new IllegalStateException("The SOAP client passed into the JaxWsHandler does not have the necessary context handler on its binding chain.");
    }
}

