/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.AdPartner;
import com.google.ads.admanager.v1.AdPartnerServiceClient;
import com.google.ads.admanager.v1.GetAdPartnerRequest;
import com.google.ads.admanager.v1.ListAdPartnersRequest;
import com.google.ads.admanager.v1.ListAdPartnersResponse;
import com.google.ads.admanager.v1.stub.AdPartnerServiceStub;
import com.google.ads.admanager.v1.stub.AdPartnerServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonAdPartnerServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonAdPartnerServiceStub
extends AdPartnerServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetAdPartnerRequest, AdPartner> getAdPartnerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.AdPartnerService/GetAdPartner").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/adPartners/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AdPartner.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListAdPartnersRequest, ListAdPartnersResponse> listAdPartnersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.AdPartnerService/ListAdPartners").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/adPartners", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListAdPartnersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetAdPartnerRequest, AdPartner> getAdPartnerCallable;
    private final UnaryCallable<ListAdPartnersRequest, ListAdPartnersResponse> listAdPartnersCallable;
    private final UnaryCallable<ListAdPartnersRequest, AdPartnerServiceClient.ListAdPartnersPagedResponse> listAdPartnersPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAdPartnerServiceStub create(AdPartnerServiceStubSettings settings) throws IOException {
        return new HttpJsonAdPartnerServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAdPartnerServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAdPartnerServiceStub(AdPartnerServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonAdPartnerServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAdPartnerServiceStub(AdPartnerServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAdPartnerServiceStub(AdPartnerServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAdPartnerServiceCallableFactory());
    }

    protected HttpJsonAdPartnerServiceStub(AdPartnerServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getAdPartnerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAdPartnerMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listAdPartnersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listAdPartnersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getAdPartnerCallable = callableFactory.createUnaryCallable(getAdPartnerTransportSettings, settings.getAdPartnerSettings(), clientContext);
        this.listAdPartnersCallable = callableFactory.createUnaryCallable(listAdPartnersTransportSettings, settings.listAdPartnersSettings(), clientContext);
        this.listAdPartnersPagedCallable = callableFactory.createPagedCallable(listAdPartnersTransportSettings, settings.listAdPartnersSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getAdPartnerMethodDescriptor);
        methodDescriptors.add(listAdPartnersMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetAdPartnerRequest, AdPartner> getAdPartnerCallable() {
        return this.getAdPartnerCallable;
    }

    @Override
    public UnaryCallable<ListAdPartnersRequest, ListAdPartnersResponse> listAdPartnersCallable() {
        return this.listAdPartnersCallable;
    }

    @Override
    public UnaryCallable<ListAdPartnersRequest, AdPartnerServiceClient.ListAdPartnersPagedResponse> listAdPartnersPagedCallable() {
        return this.listAdPartnersPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

