/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetNetworkRequest;
import com.google.ads.admanager.v1.Network;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.NetworkServiceSettings;
import com.google.ads.admanager.v1.stub.NetworkServiceStub;
import com.google.ads.admanager.v1.stub.NetworkServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class NetworkServiceClient
implements BackgroundResource {
    private final NetworkServiceSettings settings;
    private final NetworkServiceStub stub;

    public static final NetworkServiceClient create() throws IOException {
        return NetworkServiceClient.create(NetworkServiceSettings.newBuilder().build());
    }

    public static final NetworkServiceClient create(NetworkServiceSettings settings) throws IOException {
        return new NetworkServiceClient(settings);
    }

    public static final NetworkServiceClient create(NetworkServiceStub stub) {
        return new NetworkServiceClient(stub);
    }

    protected NetworkServiceClient(NetworkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected NetworkServiceClient(NetworkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworkServiceSettings getSettings() {
        return this.settings;
    }

    public NetworkServiceStub getStub() {
        return this.stub;
    }

    public final Network getNetwork(NetworkName name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(String name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(GetNetworkRequest request) {
        return (Network)this.getNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkRequest, Network> getNetworkCallable() {
        return this.stub.getNetworkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

