/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.ExportSavedReportMetadata;
import com.google.ads.admanager.v1.ExportSavedReportRequest;
import com.google.ads.admanager.v1.ExportSavedReportResponse;
import com.google.ads.admanager.v1.ReportName;
import com.google.ads.admanager.v1.ReportServiceSettings;
import com.google.ads.admanager.v1.stub.ReportServiceStub;
import com.google.ads.admanager.v1.stub.ReportServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ReportServiceClient
implements BackgroundResource {
    private final ReportServiceSettings settings;
    private final ReportServiceStub stub;
    private final OperationsClient httpJsonOperationsClient;

    public static final ReportServiceClient create() throws IOException {
        return ReportServiceClient.create(ReportServiceSettings.newBuilder().build());
    }

    public static final ReportServiceClient create(ReportServiceSettings settings) throws IOException {
        return new ReportServiceClient(settings);
    }

    public static final ReportServiceClient create(ReportServiceStub stub) {
        return new ReportServiceClient(stub);
    }

    protected ReportServiceClient(ReportServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReportServiceStubSettings)settings.getStubSettings()).createStub();
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ReportServiceClient(ReportServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ReportServiceSettings getSettings() {
        return this.settings;
    }

    public ReportServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<ExportSavedReportResponse, ExportSavedReportMetadata> exportSavedReportAsync(ReportName report) {
        ExportSavedReportRequest request = ExportSavedReportRequest.newBuilder().setReport(report == null ? null : report.toString()).build();
        return this.exportSavedReportAsync(request);
    }

    public final OperationFuture<ExportSavedReportResponse, ExportSavedReportMetadata> exportSavedReportAsync(String report) {
        ExportSavedReportRequest request = ExportSavedReportRequest.newBuilder().setReport(report).build();
        return this.exportSavedReportAsync(request);
    }

    public final OperationFuture<ExportSavedReportResponse, ExportSavedReportMetadata> exportSavedReportAsync(ExportSavedReportRequest request) {
        return this.exportSavedReportOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportSavedReportRequest, ExportSavedReportResponse, ExportSavedReportMetadata> exportSavedReportOperationCallable() {
        return this.stub.exportSavedReportOperationCallable();
    }

    public final UnaryCallable<ExportSavedReportRequest, Operation> exportSavedReportCallable() {
        return this.stub.exportSavedReportCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

