/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetLabelRequest;
import com.google.ads.admanager.v1.Label;
import com.google.ads.admanager.v1.LabelServiceClient;
import com.google.ads.admanager.v1.ListLabelsRequest;
import com.google.ads.admanager.v1.ListLabelsResponse;
import com.google.ads.admanager.v1.stub.HttpJsonLabelServiceStub;
import com.google.ads.admanager.v1.stub.LabelServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class LabelServiceStubSettings
extends StubSettings<LabelServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetLabelRequest, Label> getLabelSettings;
    private final PagedCallSettings<ListLabelsRequest, ListLabelsResponse, LabelServiceClient.ListLabelsPagedResponse> listLabelsSettings;
    private static final PagedListDescriptor<ListLabelsRequest, ListLabelsResponse, Label> LIST_LABELS_PAGE_STR_DESC = new PagedListDescriptor<ListLabelsRequest, ListLabelsResponse, Label>(){

        public String emptyToken() {
            return "";
        }

        public ListLabelsRequest injectToken(ListLabelsRequest payload, String token) {
            return ListLabelsRequest.newBuilder((ListLabelsRequest)payload).setPageToken(token).build();
        }

        public ListLabelsRequest injectPageSize(ListLabelsRequest payload, int pageSize) {
            return ListLabelsRequest.newBuilder((ListLabelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLabelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLabelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Label> extractResources(ListLabelsResponse payload) {
            return payload.getLabelsList() == null ? ImmutableList.of() : payload.getLabelsList();
        }
    };
    private static final PagedListResponseFactory<ListLabelsRequest, ListLabelsResponse, LabelServiceClient.ListLabelsPagedResponse> LIST_LABELS_PAGE_STR_FACT = new PagedListResponseFactory<ListLabelsRequest, ListLabelsResponse, LabelServiceClient.ListLabelsPagedResponse>(){

        public ApiFuture<LabelServiceClient.ListLabelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLabelsRequest, ListLabelsResponse> callable, ListLabelsRequest request, ApiCallContext context, ApiFuture<ListLabelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LABELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LabelServiceClient.ListLabelsPagedResponse.createAsync((PageContext<ListLabelsRequest, ListLabelsResponse, Label>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetLabelRequest, Label> getLabelSettings() {
        return this.getLabelSettings;
    }

    public PagedCallSettings<ListLabelsRequest, ListLabelsResponse, LabelServiceClient.ListLabelsPagedResponse> listLabelsSettings() {
        return this.listLabelsSettings;
    }

    public LabelServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonLabelServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LabelServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LabelServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LabelServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getLabelSettings = settingsBuilder.getLabelSettings().build();
        this.listLabelsSettings = settingsBuilder.listLabelsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LabelServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetLabelRequest, Label> getLabelSettings;
        private final PagedCallSettings.Builder<ListLabelsRequest, ListLabelsResponse, LabelServiceClient.ListLabelsPagedResponse> listLabelsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getLabelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLabelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LABELS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getLabelSettings, this.listLabelsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(LabelServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getLabelSettings = settings.getLabelSettings.toBuilder();
            this.listLabelsSettings = settings.listLabelsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getLabelSettings, this.listLabelsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LabelServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LabelServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LabelServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LabelServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getLabelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetLabelRequest, Label> getLabelSettings() {
            return this.getLabelSettings;
        }

        public PagedCallSettings.Builder<ListLabelsRequest, ListLabelsResponse, LabelServiceClient.ListLabelsPagedResponse> listLabelsSettings() {
            return this.listLabelsSettings;
        }

        public LabelServiceStubSettings build() throws IOException {
            return new LabelServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

