/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetOperatingSystemRequest;
import com.google.ads.admanager.v1.ListOperatingSystemsRequest;
import com.google.ads.admanager.v1.ListOperatingSystemsResponse;
import com.google.ads.admanager.v1.OperatingSystem;
import com.google.ads.admanager.v1.OperatingSystemServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonOperatingSystemServiceStub;
import com.google.ads.admanager.v1.stub.OperatingSystemServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class OperatingSystemServiceStubSettings
extends StubSettings<OperatingSystemServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetOperatingSystemRequest, OperatingSystem> getOperatingSystemSettings;
    private final PagedCallSettings<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystemServiceClient.ListOperatingSystemsPagedResponse> listOperatingSystemsSettings;
    private static final PagedListDescriptor<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem> LIST_OPERATING_SYSTEMS_PAGE_STR_DESC = new PagedListDescriptor<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem>(){

        public String emptyToken() {
            return "";
        }

        public ListOperatingSystemsRequest injectToken(ListOperatingSystemsRequest payload, String token) {
            return ListOperatingSystemsRequest.newBuilder((ListOperatingSystemsRequest)payload).setPageToken(token).build();
        }

        public ListOperatingSystemsRequest injectPageSize(ListOperatingSystemsRequest payload, int pageSize) {
            return ListOperatingSystemsRequest.newBuilder((ListOperatingSystemsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOperatingSystemsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOperatingSystemsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<OperatingSystem> extractResources(ListOperatingSystemsResponse payload) {
            return payload.getOperatingSystemsList();
        }
    };
    private static final PagedListResponseFactory<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystemServiceClient.ListOperatingSystemsPagedResponse> LIST_OPERATING_SYSTEMS_PAGE_STR_FACT = new PagedListResponseFactory<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystemServiceClient.ListOperatingSystemsPagedResponse>(){

        public ApiFuture<OperatingSystemServiceClient.ListOperatingSystemsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOperatingSystemsRequest, ListOperatingSystemsResponse> callable, ListOperatingSystemsRequest request, ApiCallContext context, ApiFuture<ListOperatingSystemsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_OPERATING_SYSTEMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OperatingSystemServiceClient.ListOperatingSystemsPagedResponse.createAsync((PageContext<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetOperatingSystemRequest, OperatingSystem> getOperatingSystemSettings() {
        return this.getOperatingSystemSettings;
    }

    public PagedCallSettings<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystemServiceClient.ListOperatingSystemsPagedResponse> listOperatingSystemsSettings() {
        return this.listOperatingSystemsSettings;
    }

    public OperatingSystemServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOperatingSystemServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OperatingSystemServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OperatingSystemServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OperatingSystemServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getOperatingSystemSettings = settingsBuilder.getOperatingSystemSettings().build();
        this.listOperatingSystemsSettings = settingsBuilder.listOperatingSystemsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OperatingSystemServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetOperatingSystemRequest, OperatingSystem> getOperatingSystemSettings;
        private final PagedCallSettings.Builder<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystemServiceClient.ListOperatingSystemsPagedResponse> listOperatingSystemsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getOperatingSystemSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOperatingSystemsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_OPERATING_SYSTEMS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperatingSystemSettings, this.listOperatingSystemsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(OperatingSystemServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getOperatingSystemSettings = settings.getOperatingSystemSettings.toBuilder();
            this.listOperatingSystemsSettings = settings.listOperatingSystemsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperatingSystemSettings, this.listOperatingSystemsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OperatingSystemServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OperatingSystemServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OperatingSystemServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OperatingSystemServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getOperatingSystemSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listOperatingSystemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetOperatingSystemRequest, OperatingSystem> getOperatingSystemSettings() {
            return this.getOperatingSystemSettings;
        }

        public PagedCallSettings.Builder<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystemServiceClient.ListOperatingSystemsPagedResponse> listOperatingSystemsSettings() {
            return this.listOperatingSystemsSettings;
        }

        public OperatingSystemServiceStubSettings build() throws IOException {
            return new OperatingSystemServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

