/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CreatePrivateAuctionRequest;
import com.google.ads.admanager.v1.GetPrivateAuctionRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionsRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionsResponse;
import com.google.ads.admanager.v1.PrivateAuction;
import com.google.ads.admanager.v1.PrivateAuctionServiceClient;
import com.google.ads.admanager.v1.UpdatePrivateAuctionRequest;
import com.google.ads.admanager.v1.stub.HttpJsonPrivateAuctionServiceCallableFactory;
import com.google.ads.admanager.v1.stub.PrivateAuctionServiceStub;
import com.google.ads.admanager.v1.stub.PrivateAuctionServiceStubSettings;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonPrivateAuctionServiceStub
extends PrivateAuctionServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetPrivateAuctionRequest, PrivateAuction> getPrivateAuctionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.PrivateAuctionService/GetPrivateAuction").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/privateAuctions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PrivateAuction.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse> listPrivateAuctionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.PrivateAuctionService/ListPrivateAuctions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/privateAuctions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListPrivateAuctionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreatePrivateAuctionRequest, PrivateAuction> createPrivateAuctionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.PrivateAuctionService/CreatePrivateAuction").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/privateAuctions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("privateAuction", (Message)request.getPrivateAuction(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PrivateAuction.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdatePrivateAuctionRequest, PrivateAuction> updatePrivateAuctionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.PrivateAuctionService/UpdatePrivateAuction").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{privateAuction.name=networks/*/privateAuctions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "privateAuction.name", (Object)request.getPrivateAuction().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("privateAuction", (Message)request.getPrivateAuction(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PrivateAuction.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetPrivateAuctionRequest, PrivateAuction> getPrivateAuctionCallable;
    private final UnaryCallable<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse> listPrivateAuctionsCallable;
    private final UnaryCallable<ListPrivateAuctionsRequest, PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse> listPrivateAuctionsPagedCallable;
    private final UnaryCallable<CreatePrivateAuctionRequest, PrivateAuction> createPrivateAuctionCallable;
    private final UnaryCallable<UpdatePrivateAuctionRequest, PrivateAuction> updatePrivateAuctionCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonPrivateAuctionServiceStub create(PrivateAuctionServiceStubSettings settings) throws IOException {
        return new HttpJsonPrivateAuctionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonPrivateAuctionServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonPrivateAuctionServiceStub(PrivateAuctionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonPrivateAuctionServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonPrivateAuctionServiceStub(PrivateAuctionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonPrivateAuctionServiceStub(PrivateAuctionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonPrivateAuctionServiceCallableFactory());
    }

    protected HttpJsonPrivateAuctionServiceStub(PrivateAuctionServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getPrivateAuctionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPrivateAuctionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listPrivateAuctionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listPrivateAuctionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createPrivateAuctionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createPrivateAuctionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updatePrivateAuctionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updatePrivateAuctionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("private_auction.name", String.valueOf(request.getPrivateAuction().getName()));
            return builder.build();
        }).build();
        this.getPrivateAuctionCallable = callableFactory.createUnaryCallable(getPrivateAuctionTransportSettings, settings.getPrivateAuctionSettings(), clientContext);
        this.listPrivateAuctionsCallable = callableFactory.createUnaryCallable(listPrivateAuctionsTransportSettings, settings.listPrivateAuctionsSettings(), clientContext);
        this.listPrivateAuctionsPagedCallable = callableFactory.createPagedCallable(listPrivateAuctionsTransportSettings, settings.listPrivateAuctionsSettings(), clientContext);
        this.createPrivateAuctionCallable = callableFactory.createUnaryCallable(createPrivateAuctionTransportSettings, settings.createPrivateAuctionSettings(), clientContext);
        this.updatePrivateAuctionCallable = callableFactory.createUnaryCallable(updatePrivateAuctionTransportSettings, settings.updatePrivateAuctionSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getPrivateAuctionMethodDescriptor);
        methodDescriptors.add(listPrivateAuctionsMethodDescriptor);
        methodDescriptors.add(createPrivateAuctionMethodDescriptor);
        methodDescriptors.add(updatePrivateAuctionMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetPrivateAuctionRequest, PrivateAuction> getPrivateAuctionCallable() {
        return this.getPrivateAuctionCallable;
    }

    @Override
    public UnaryCallable<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse> listPrivateAuctionsCallable() {
        return this.listPrivateAuctionsCallable;
    }

    @Override
    public UnaryCallable<ListPrivateAuctionsRequest, PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse> listPrivateAuctionsPagedCallable() {
        return this.listPrivateAuctionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreatePrivateAuctionRequest, PrivateAuction> createPrivateAuctionCallable() {
        return this.createPrivateAuctionCallable;
    }

    @Override
    public UnaryCallable<UpdatePrivateAuctionRequest, PrivateAuction> updatePrivateAuctionCallable() {
        return this.updatePrivateAuctionCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

