/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetOperatingSystemRequest;
import com.google.ads.admanager.v1.ListOperatingSystemsRequest;
import com.google.ads.admanager.v1.ListOperatingSystemsResponse;
import com.google.ads.admanager.v1.OperatingSystem;
import com.google.ads.admanager.v1.OperatingSystemServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonOperatingSystemServiceCallableFactory;
import com.google.ads.admanager.v1.stub.OperatingSystemServiceStub;
import com.google.ads.admanager.v1.stub.OperatingSystemServiceStubSettings;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonOperatingSystemServiceStub
extends OperatingSystemServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetOperatingSystemRequest, OperatingSystem> getOperatingSystemMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.OperatingSystemService/GetOperatingSystem").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/operatingSystems/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)OperatingSystem.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListOperatingSystemsRequest, ListOperatingSystemsResponse> listOperatingSystemsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.OperatingSystemService/ListOperatingSystems").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/operatingSystems", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListOperatingSystemsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetOperatingSystemRequest, OperatingSystem> getOperatingSystemCallable;
    private final UnaryCallable<ListOperatingSystemsRequest, ListOperatingSystemsResponse> listOperatingSystemsCallable;
    private final UnaryCallable<ListOperatingSystemsRequest, OperatingSystemServiceClient.ListOperatingSystemsPagedResponse> listOperatingSystemsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonOperatingSystemServiceStub create(OperatingSystemServiceStubSettings settings) throws IOException {
        return new HttpJsonOperatingSystemServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonOperatingSystemServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonOperatingSystemServiceStub(OperatingSystemServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonOperatingSystemServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonOperatingSystemServiceStub(OperatingSystemServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonOperatingSystemServiceStub(OperatingSystemServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonOperatingSystemServiceCallableFactory());
    }

    protected HttpJsonOperatingSystemServiceStub(OperatingSystemServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getOperatingSystemTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getOperatingSystemMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listOperatingSystemsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listOperatingSystemsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getOperatingSystemCallable = callableFactory.createUnaryCallable(getOperatingSystemTransportSettings, settings.getOperatingSystemSettings(), clientContext);
        this.listOperatingSystemsCallable = callableFactory.createUnaryCallable(listOperatingSystemsTransportSettings, settings.listOperatingSystemsSettings(), clientContext);
        this.listOperatingSystemsPagedCallable = callableFactory.createPagedCallable(listOperatingSystemsTransportSettings, settings.listOperatingSystemsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getOperatingSystemMethodDescriptor);
        methodDescriptors.add(listOperatingSystemsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetOperatingSystemRequest, OperatingSystem> getOperatingSystemCallable() {
        return this.getOperatingSystemCallable;
    }

    @Override
    public UnaryCallable<ListOperatingSystemsRequest, ListOperatingSystemsResponse> listOperatingSystemsCallable() {
        return this.listOperatingSystemsCallable;
    }

    @Override
    public UnaryCallable<ListOperatingSystemsRequest, OperatingSystemServiceClient.ListOperatingSystemsPagedResponse> listOperatingSystemsPagedCallable() {
        return this.listOperatingSystemsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

