/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.AdBreak;
import com.google.ads.admanager.v1.AdBreakName;
import com.google.ads.admanager.v1.AdBreakServiceSettings;
import com.google.ads.admanager.v1.CreateAdBreakRequest;
import com.google.ads.admanager.v1.DeleteAdBreakRequest;
import com.google.ads.admanager.v1.GetAdBreakRequest;
import com.google.ads.admanager.v1.ListAdBreaksRequest;
import com.google.ads.admanager.v1.ListAdBreaksResponse;
import com.google.ads.admanager.v1.LiveStreamEventName;
import com.google.ads.admanager.v1.UpdateAdBreakRequest;
import com.google.ads.admanager.v1.stub.AdBreakServiceStub;
import com.google.ads.admanager.v1.stub.AdBreakServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AdBreakServiceClient
implements BackgroundResource {
    private final AdBreakServiceSettings settings;
    private final AdBreakServiceStub stub;

    public static final AdBreakServiceClient create() throws IOException {
        return AdBreakServiceClient.create(AdBreakServiceSettings.newBuilder().build());
    }

    public static final AdBreakServiceClient create(AdBreakServiceSettings settings) throws IOException {
        return new AdBreakServiceClient(settings);
    }

    public static final AdBreakServiceClient create(AdBreakServiceStub stub) {
        return new AdBreakServiceClient(stub);
    }

    protected AdBreakServiceClient(AdBreakServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdBreakServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdBreakServiceClient(AdBreakServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdBreakServiceSettings getSettings() {
        return this.settings;
    }

    public AdBreakServiceStub getStub() {
        return this.stub;
    }

    public final AdBreak getAdBreak(AdBreakName name) {
        GetAdBreakRequest request = GetAdBreakRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAdBreak(request);
    }

    public final AdBreak getAdBreak(String name) {
        GetAdBreakRequest request = GetAdBreakRequest.newBuilder().setName(name).build();
        return this.getAdBreak(request);
    }

    public final AdBreak getAdBreak(GetAdBreakRequest request) {
        return (AdBreak)this.getAdBreakCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdBreakRequest, AdBreak> getAdBreakCallable() {
        return this.stub.getAdBreakCallable();
    }

    public final ListAdBreaksPagedResponse listAdBreaks(LiveStreamEventName parent) {
        ListAdBreaksRequest request = ListAdBreaksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAdBreaks(request);
    }

    public final ListAdBreaksPagedResponse listAdBreaks(String parent) {
        ListAdBreaksRequest request = ListAdBreaksRequest.newBuilder().setParent(parent).build();
        return this.listAdBreaks(request);
    }

    public final ListAdBreaksPagedResponse listAdBreaks(ListAdBreaksRequest request) {
        return (ListAdBreaksPagedResponse)((Object)this.listAdBreaksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAdBreaksRequest, ListAdBreaksPagedResponse> listAdBreaksPagedCallable() {
        return this.stub.listAdBreaksPagedCallable();
    }

    public final UnaryCallable<ListAdBreaksRequest, ListAdBreaksResponse> listAdBreaksCallable() {
        return this.stub.listAdBreaksCallable();
    }

    public final AdBreak createAdBreak(LiveStreamEventName parent, AdBreak adBreak) {
        CreateAdBreakRequest request = CreateAdBreakRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAdBreak(adBreak).build();
        return this.createAdBreak(request);
    }

    public final AdBreak createAdBreak(String parent, AdBreak adBreak) {
        CreateAdBreakRequest request = CreateAdBreakRequest.newBuilder().setParent(parent).setAdBreak(adBreak).build();
        return this.createAdBreak(request);
    }

    public final AdBreak createAdBreak(CreateAdBreakRequest request) {
        return (AdBreak)this.createAdBreakCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAdBreakRequest, AdBreak> createAdBreakCallable() {
        return this.stub.createAdBreakCallable();
    }

    public final AdBreak updateAdBreak(AdBreak adBreak, FieldMask updateMask) {
        UpdateAdBreakRequest request = UpdateAdBreakRequest.newBuilder().setAdBreak(adBreak).setUpdateMask(updateMask).build();
        return this.updateAdBreak(request);
    }

    public final AdBreak updateAdBreak(UpdateAdBreakRequest request) {
        return (AdBreak)this.updateAdBreakCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAdBreakRequest, AdBreak> updateAdBreakCallable() {
        return this.stub.updateAdBreakCallable();
    }

    public final void deleteAdBreak(AdBreakName name) {
        DeleteAdBreakRequest request = DeleteAdBreakRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAdBreak(request);
    }

    public final void deleteAdBreak(String name) {
        DeleteAdBreakRequest request = DeleteAdBreakRequest.newBuilder().setName(name).build();
        this.deleteAdBreak(request);
    }

    public final void deleteAdBreak(DeleteAdBreakRequest request) {
        this.deleteAdBreakCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAdBreakRequest, Empty> deleteAdBreakCallable() {
        return this.stub.deleteAdBreakCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAdBreaksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak, ListAdBreaksPage, ListAdBreaksFixedSizeCollection> {
        private ListAdBreaksFixedSizeCollection(List<ListAdBreaksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAdBreaksFixedSizeCollection createEmptyCollection() {
            return new ListAdBreaksFixedSizeCollection(null, 0);
        }

        protected ListAdBreaksFixedSizeCollection createCollection(List<ListAdBreaksPage> pages, int collectionSize) {
            return new ListAdBreaksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAdBreaksPage
    extends AbstractPage<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak, ListAdBreaksPage> {
        private ListAdBreaksPage(PageContext<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak> context, ListAdBreaksResponse response) {
            super(context, (Object)response);
        }

        private static ListAdBreaksPage createEmptyPage() {
            return new ListAdBreaksPage(null, null);
        }

        protected ListAdBreaksPage createPage(PageContext<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak> context, ListAdBreaksResponse response) {
            return new ListAdBreaksPage(context, response);
        }

        public ApiFuture<ListAdBreaksPage> createPageAsync(PageContext<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak> context, ApiFuture<ListAdBreaksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAdBreaksPagedResponse
    extends AbstractPagedListResponse<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak, ListAdBreaksPage, ListAdBreaksFixedSizeCollection> {
        public static ApiFuture<ListAdBreaksPagedResponse> createAsync(PageContext<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak> context, ApiFuture<ListAdBreaksResponse> futureResponse) {
            ApiFuture<ListAdBreaksPage> futurePage = ListAdBreaksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAdBreaksPagedResponse((ListAdBreaksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAdBreaksPagedResponse(ListAdBreaksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAdBreaksFixedSizeCollection.createEmptyCollection());
        }
    }
}

