/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetProgrammaticBuyerRequest;
import com.google.ads.admanager.v1.ListProgrammaticBuyersRequest;
import com.google.ads.admanager.v1.ListProgrammaticBuyersResponse;
import com.google.ads.admanager.v1.ProgrammaticBuyer;
import com.google.ads.admanager.v1.ProgrammaticBuyerServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonProgrammaticBuyerServiceStub;
import com.google.ads.admanager.v1.stub.ProgrammaticBuyerServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ProgrammaticBuyerServiceStubSettings
extends StubSettings<ProgrammaticBuyerServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetProgrammaticBuyerRequest, ProgrammaticBuyer> getProgrammaticBuyerSettings;
    private final PagedCallSettings<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyerServiceClient.ListProgrammaticBuyersPagedResponse> listProgrammaticBuyersSettings;
    private static final PagedListDescriptor<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer> LIST_PROGRAMMATIC_BUYERS_PAGE_STR_DESC = new PagedListDescriptor<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer>(){

        public String emptyToken() {
            return "";
        }

        public ListProgrammaticBuyersRequest injectToken(ListProgrammaticBuyersRequest payload, String token) {
            return ListProgrammaticBuyersRequest.newBuilder((ListProgrammaticBuyersRequest)payload).setPageToken(token).build();
        }

        public ListProgrammaticBuyersRequest injectPageSize(ListProgrammaticBuyersRequest payload, int pageSize) {
            return ListProgrammaticBuyersRequest.newBuilder((ListProgrammaticBuyersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProgrammaticBuyersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProgrammaticBuyersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ProgrammaticBuyer> extractResources(ListProgrammaticBuyersResponse payload) {
            return payload.getProgrammaticBuyersList();
        }
    };
    private static final PagedListResponseFactory<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyerServiceClient.ListProgrammaticBuyersPagedResponse> LIST_PROGRAMMATIC_BUYERS_PAGE_STR_FACT = new PagedListResponseFactory<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyerServiceClient.ListProgrammaticBuyersPagedResponse>(){

        public ApiFuture<ProgrammaticBuyerServiceClient.ListProgrammaticBuyersPagedResponse> getFuturePagedResponse(UnaryCallable<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse> callable, ListProgrammaticBuyersRequest request, ApiCallContext context, ApiFuture<ListProgrammaticBuyersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROGRAMMATIC_BUYERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProgrammaticBuyerServiceClient.ListProgrammaticBuyersPagedResponse.createAsync((PageContext<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetProgrammaticBuyerRequest, ProgrammaticBuyer> getProgrammaticBuyerSettings() {
        return this.getProgrammaticBuyerSettings;
    }

    public PagedCallSettings<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyerServiceClient.ListProgrammaticBuyersPagedResponse> listProgrammaticBuyersSettings() {
        return this.listProgrammaticBuyersSettings;
    }

    public ProgrammaticBuyerServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonProgrammaticBuyerServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ProgrammaticBuyerServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProgrammaticBuyerServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ProgrammaticBuyerServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getProgrammaticBuyerSettings = settingsBuilder.getProgrammaticBuyerSettings().build();
        this.listProgrammaticBuyersSettings = settingsBuilder.listProgrammaticBuyersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ProgrammaticBuyerServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetProgrammaticBuyerRequest, ProgrammaticBuyer> getProgrammaticBuyerSettings;
        private final PagedCallSettings.Builder<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyerServiceClient.ListProgrammaticBuyersPagedResponse> listProgrammaticBuyersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getProgrammaticBuyerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProgrammaticBuyersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROGRAMMATIC_BUYERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getProgrammaticBuyerSettings, this.listProgrammaticBuyersSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ProgrammaticBuyerServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getProgrammaticBuyerSettings = settings.getProgrammaticBuyerSettings.toBuilder();
            this.listProgrammaticBuyersSettings = settings.listProgrammaticBuyersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getProgrammaticBuyerSettings, this.listProgrammaticBuyersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ProgrammaticBuyerServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ProgrammaticBuyerServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProgrammaticBuyerServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ProgrammaticBuyerServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getProgrammaticBuyerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listProgrammaticBuyersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetProgrammaticBuyerRequest, ProgrammaticBuyer> getProgrammaticBuyerSettings() {
            return this.getProgrammaticBuyerSettings;
        }

        public PagedCallSettings.Builder<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyerServiceClient.ListProgrammaticBuyersPagedResponse> listProgrammaticBuyersSettings() {
            return this.listProgrammaticBuyersSettings;
        }

        public ProgrammaticBuyerServiceStubSettings build() throws IOException {
            return new ProgrammaticBuyerServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

