/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetUserRequest;
import com.google.ads.admanager.v1.ListUsersRequest;
import com.google.ads.admanager.v1.ListUsersResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.User;
import com.google.ads.admanager.v1.UserName;
import com.google.ads.admanager.v1.UserServiceSettings;
import com.google.ads.admanager.v1.stub.UserServiceStub;
import com.google.ads.admanager.v1.stub.UserServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class UserServiceClient
implements BackgroundResource {
    private final UserServiceSettings settings;
    private final UserServiceStub stub;

    public static final UserServiceClient create() throws IOException {
        return UserServiceClient.create(UserServiceSettings.newBuilder().build());
    }

    public static final UserServiceClient create(UserServiceSettings settings) throws IOException {
        return new UserServiceClient(settings);
    }

    public static final UserServiceClient create(UserServiceStub stub) {
        return new UserServiceClient(stub);
    }

    protected UserServiceClient(UserServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UserServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected UserServiceClient(UserServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final UserServiceSettings getSettings() {
        return this.settings;
    }

    public UserServiceStub getStub() {
        return this.stub;
    }

    public final User getUser(UserName name) {
        GetUserRequest request = GetUserRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getUser(request);
    }

    public final User getUser(String name) {
        GetUserRequest request = GetUserRequest.newBuilder().setName(name).build();
        return this.getUser(request);
    }

    public final User getUser(GetUserRequest request) {
        return (User)this.getUserCallable().call((Object)request);
    }

    public final UnaryCallable<GetUserRequest, User> getUserCallable() {
        return this.stub.getUserCallable();
    }

    public final ListUsersPagedResponse listUsers(NetworkName parent) {
        ListUsersRequest request = ListUsersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUsers(request);
    }

    public final ListUsersPagedResponse listUsers(String parent) {
        ListUsersRequest request = ListUsersRequest.newBuilder().setParent(parent).build();
        return this.listUsers(request);
    }

    public final ListUsersPagedResponse listUsers(ListUsersRequest request) {
        return (ListUsersPagedResponse)((Object)this.listUsersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUsersRequest, ListUsersPagedResponse> listUsersPagedCallable() {
        return this.stub.listUsersPagedCallable();
    }

    public final UnaryCallable<ListUsersRequest, ListUsersResponse> listUsersCallable() {
        return this.stub.listUsersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUsersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUsersRequest, ListUsersResponse, User, ListUsersPage, ListUsersFixedSizeCollection> {
        private ListUsersFixedSizeCollection(List<ListUsersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUsersFixedSizeCollection createEmptyCollection() {
            return new ListUsersFixedSizeCollection(null, 0);
        }

        protected ListUsersFixedSizeCollection createCollection(List<ListUsersPage> pages, int collectionSize) {
            return new ListUsersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUsersPage
    extends AbstractPage<ListUsersRequest, ListUsersResponse, User, ListUsersPage> {
        private ListUsersPage(PageContext<ListUsersRequest, ListUsersResponse, User> context, ListUsersResponse response) {
            super(context, (Object)response);
        }

        private static ListUsersPage createEmptyPage() {
            return new ListUsersPage(null, null);
        }

        protected ListUsersPage createPage(PageContext<ListUsersRequest, ListUsersResponse, User> context, ListUsersResponse response) {
            return new ListUsersPage(context, response);
        }

        public ApiFuture<ListUsersPage> createPageAsync(PageContext<ListUsersRequest, ListUsersResponse, User> context, ApiFuture<ListUsersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUsersPagedResponse
    extends AbstractPagedListResponse<ListUsersRequest, ListUsersResponse, User, ListUsersPage, ListUsersFixedSizeCollection> {
        public static ApiFuture<ListUsersPagedResponse> createAsync(PageContext<ListUsersRequest, ListUsersResponse, User> context, ApiFuture<ListUsersResponse> futureResponse) {
            ApiFuture<ListUsersPage> futurePage = ListUsersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUsersPagedResponse((ListUsersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUsersPagedResponse(ListUsersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUsersFixedSizeCollection.createEmptyCollection());
        }
    }
}

